#include <stdio.h>
#include <sys/types.h>
#include <dlfcn.h>

pid_t __getpid(void)
{
  static int initdone;
  static pid_t (*c_getpid)();

  if(!initdone) {
    void *lib;

    if(!(lib = dlopen("libc.so", RTLD_NOW))) {
      fprintf(stderr, "libc.so: %s\n", dlerror());
      exit(-1);
    }

    if(!(c_getpid = dlsym(lib, "__getpid"))) {
      fprintf(stderr, "getpid: %s\n", dlerror());
      exit(-1);
    }
    initdone++;
  }

  return c_getpid() & 15;
}

pid_t getpid(void) {return __getpid(); }
