#include "runix.h"
#include "rpc/runix_prot.h"
#include "svc/runix_server.h"

unixerr enc_errno(int code)
{
  switch(code) {
  case 0:
    return 0;
#ifdef EPERM
  case EPERM:
    return R_EPERM;
#endif
#ifdef ENOENT
  case ENOENT:
    return R_ENOENT;
#endif
#ifdef ENOEXEC
  case ENOEXEC:
    return R_ENOEXEC;
#endif
#ifdef EBADF
  case EBADF:
    return R_EBADF;
#endif
#ifdef EACCES
  case EACCES:
    return R_EACCES;
#endif
#ifdef EEXIST
  case EEXIST:
    return R_EEXIST;
#endif
#ifdef ENOTDIR
  case ENOTDIR:
    return R_ENOTDIR;
#endif
#ifdef EISDIR
  case EISDIR:
    return R_EISDIR;
#endif
#ifdef ENOSPC
  case ENOSPC:
    return R_ENOSPC;
#endif
#ifdef EROFS
  case EROFS:
    return R_EROFS;
#endif
#ifdef ENOTEMPTY
  case ENOTEMPTY:
    return R_ENOTEMPTY;
#endif
#ifdef ELOOP
  case ELOOP:
    return R_ELOOP;
#endif
#ifdef EDQUOT
  case EDQUOT:
    return R_EDQUOT;
#endif
  default:
    return R_EWIRE;
  }
}

int dec_open(int flags)
{
  static int bm[] = {O_RDONLY, O_WRONLY, O_RDWR};
  
  return bm[flags&3] | (flags & RO_EXCL ? O_EXCL : 0) | 
    (flags & RO_CREAT ? O_CREAT : 0) |
    (flags & RO_TRUNC ? O_TRUNC : 0) |
    (flags & RO_APPEND ? O_APPEND : 0);
}

int dec_lseek(rseek_method r)
{
  static int sm[] = {SEEK_SET, SEEK_CUR, SEEK_END};
  return sm[r];
}

rstat enc_stat(struct stat st)
{
  rstat r;
  memset(&r, 0, sizeof(r));
  r.xst_dev    = st.st_dev + DEV_SHIFT;
  r.xst_ino    = st.st_ino;
  r.xst_nlink  = st.st_nlink;
  r.xst_uid    = st.st_uid;
  r.xst_gid    = st.st_gid;
  r.xst_size   = st.st_size;
  r.xst_blocks = st.st_blocks;
  r.xst_atime  = st.st_atime;
  r.xst_mtime  = st.st_mtime;
  r.xst_ctime  = st.st_ctime;

  r.xst_mode = enc_mode(st.st_mode);
  
  return r;
}

int dec_access(u_short mode)
{
  return ((mode & RR_OK) ? R_OK : 0) |
         ((mode & RW_OK) ? W_OK : 0) |
	 ((mode & RX_OK) ? X_OK : 0) |
	 ((mode & RF_OK) ? F_OK : 0);
}

