/*
 * This is a typical robot for now. Just does what it's told  - Oleg
 */

#include "runix.h"
#include "runixd/runixd.h"
#include "rpc/runix_prot.h"
#include "svc/runix_server.h"

int_ret *
runix_open_1_svc(str path, int flags, int mode, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = open(path, dec_open(flags), mode)) == -1)
	  result.xerrno = enc_errno(errno);
	else {
	  result.retcode += FD_SHIFT;
	  result.xerrno = 0;
	}
	return (&result);
}

buf_ret *
runix_read_1_svc(int fd, int count, struct svc_req *rqstp)
{
	static buf_ret  result;
	
	if(result.buf.opq_val)
	  free(result.buf.opq_val);

	result.buf.opq_val = malloc(count);

	if((result.retcode = read(fd - FD_SHIFT, result.buf.opq_val, count)) == -1) {
	  result.xerrno = enc_errno(errno);
	  result.buf.opq_len = 0;
	} else {
	  result.xerrno = 0;
	  result.buf.opq_len = result.retcode;
	}
	return &result;
}

int_ret *
runix_write_1_svc(int fd, opq buf, int count, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = write(fd - FD_SHIFT, buf.opq_val, count)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_close_1_svc(int fd, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = close(fd - FD_SHIFT)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	
	return (&result);
}

int_ret *
runix_lseek_1_svc(int filedes, long offset, int whence, struct svc_req *rqstp)
{
	static int_ret  result;
	
	errno = 0;
	if((result.retcode = lseek(filedes - FD_SHIFT, offset, whence)) == -1 && errno)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

stat_ret *
runix_stat_1_svc(str file, struct svc_req *rqstp)
{
	static stat_ret  result;
	struct stat st;

	if((result.retcode = stat(file, &st)) == -1)
	  result.xerrno = enc_errno(errno);
	else {
	  result.xerrno = 0;
	  result.st = enc_stat(st);
	}

	return (&result);
}

stat_ret *
runix_lstat_1_svc(str file, struct svc_req *rqstp)
{
	static stat_ret  result;
	struct stat st;

	if((result.retcode = lstat(file, &st)) == -1)
	  result.xerrno = enc_errno(errno);
	else {
	  result.xerrno = 0;
	  result.st = enc_stat(st);
	}

	return (&result);
}

stat_ret *
runix_fstat_1_svc(int fd, struct svc_req *rqstp)
{
	static stat_ret  result;
	struct stat st;

	if((result.retcode = fstat(fd - FD_SHIFT, &st)) == -1)
	  result.xerrno = enc_errno(errno);
	else {
	  result.xerrno = 0;
	  result.st = enc_stat(st);
	}

	return (&result);
}

int_ret *
runix_chmod_1_svc(str file, int mode, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = chmod(file, mode)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_fchmod_1_svc(int fd, int mode, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = fchmod(fd - FD_SHIFT, mode)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_chown_1_svc(str file, long uid, long gid, struct svc_req *rqstp)
{
	static int_ret  result;
	
	if((result.retcode = chown(file, uid, gid)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_fchown_1_svc(int fd, long uid, long gid, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = fchown(fd - FD_SHIFT, uid, gid)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_umask_1_svc(int um, struct svc_req *rqstp)
{
	static int_ret  result;

	/*
	 * If THIS fails, well! People using this kind
	 * of system deserve what they get!
	 */

	result.xerrno = 0;
	result.retcode = umask(um);

	return (&result);
}

int_ret *
runix_mkdir_1_svc(str file, int mode, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = mkdir(file, mode)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_chdir_1_svc(str file, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = chdir(file)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_rmdir_1_svc(str file, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = chdir(file)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_fchdir_1_svc(int fd, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = fchdir(fd - FD_SHIFT)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_link_1_svc(str file1, str file2, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = link(file1, file2)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_unlink_1_svc(str file, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = unlink(file)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_rename_1_svc(str file1, str file2, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = rename(file1, file2)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

int_ret *
runix_symlink_1_svc(str file1, str file2, struct svc_req *rqstp)
{
	static int_ret  result;

	if((result.retcode = symlink(file1, file2)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;

	return (&result);
}

buf_ret *
runix_readlink_1_svc(str file, struct svc_req *rqstp)
{
	static buf_ret  result;
	static char buf[MAXPATHLEN];

	result.buf.opq_val = buf;

	if((result.retcode = readlink(file, buf, MAXPATHLEN)) == -1) {
	  result.xerrno = enc_errno(errno);
	  result.buf.opq_len = 0;
	} else {
	  result.xerrno = 0;
	  result.buf.opq_len = result.retcode;
	}

	return (&result);
}

dir_ret *
runix_readdir_1_svc(str name, struct svc_req *rqstp)
{
	static dir_ret result;
	struct dirent *r;
	int i, size;
	DIR *dp;
	int len;
	

	if(result.dir.dir_val) {
	  for(i = 0; i < result.dir.dir_len; i++)
	    free(result.dir.dir_val[i].d_name.opq_val);
	  free(result.dir.dir_val);
	}

	if(!(dp = opendir(name))) {
	  result.dir.dir_val=Malloc(1);
	  result.dir.dir_len=0;
	  result.retcode = -1;
	  result.xerrno = enc_errno(errno);
	  return &result;
	}
	
	size = READDIR_GRAIN;
	result.dir.dir_val = Malloc(size*sizeof(rdirent));

	errno = 0; 
	for(i = 0; r = readdir(dp); i++) {
	  if(i == size) {
	    size += READDIR_GRAIN;
	    result.dir.dir_val = Realloc(result.dir.dir_val, size*sizeof(rdirent));
	  }
	  len = strlen(r -> d_name);
	  result.dir.dir_val[i].d_fileno = r -> d_fileno;
	  result.dir.dir_val[i].d_name.opq_len = len;
	  result.dir.dir_val[i].d_name.opq_val = Malloc(len);
	  memcpy(result.dir.dir_val[i].d_name.opq_val, 
		 r -> d_name, len);
	}
	closedir(dp);
	result.dir.dir_len = i;
	
	if(errno) {
	  result.retcode = -1;
	  result.xerrno = enc_errno(errno);
	} else
	  result.retcode = result.xerrno = 0;
	
	return (&result);
}

str_ret *
runix_getwd_1_svc(struct svc_req *rqstp)
{
	static str_ret  result;
	static char buf[MAXPATHLEN];
	
	result.s = buf;

	if(!getwd(buf)) {
	  result.retcode = -1;
	  result.xerrno = enc_errno(errno);
	  *buf = '\0';
	} else {
	  result.retcode = 0;
	  result.xerrno = 0;
	}
	return (&result);
}

int_ret * runix_dup_1_svc(int fd, struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = dup(fd - FD_SHIFT)) == -1)
	  result.xerrno = enc_errno(errno);
	else {
	  result.xerrno = 0;
	  result.retcode += FD_SHIFT;
	}
	return (&result);
}  

int_ret * runix_truncate_1_svc(str file, long size, struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = truncate(file, size)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

int_ret * runix_ftruncate_1_svc(int fd, long size, struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = ftruncate(fd - FD_SHIFT, size)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

int_ret * runix_fork_1_svc(u_long handle, struct svc_req *req)
{
  int fd;
  static int_ret result;

  if((fd = getfd(handle)) == -1) {
    result.retcode = -1;
    result.xerrno = R_EWIRE;
    return &result;
  }

  switch(fork()) {
  case -1:
    result.retcode = -1;
    result.xerrno = enc_errno(errno);
    break;
  case 0:
    /*
     * Having to talk to parents about our problems is too much to handle.
     * Just trust the fate.
     */
    dup2(fd, conn_s);
    close(fd);
    return NULL;
  default:
    close(fd);
    result.retcode = result.xerrno = 0;
  }
  
  return &result;
}

int_ret * runix_utime_1_svc(char *path, rutimbuf *buf, struct svc_req *req)
{
	static int_ret  result;
	struct utimbuf ut, *put;

	if(buf) {
	  ut.actime  = buf -> actime;
	  ut.modtime = buf -> modtime;
	  put = &ut;
	} else
	  put = NULL;

	if((result.retcode = utime(path, put)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

int_ret * runix_mknod_1_svc(char *path, u_long mode, u_long dev, 
			    struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = mknod(path, dec_mode(mode), dev)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

int_ret * runix_access_1_svc(char *path, u_short mode, struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = access(path, dec_access(mode))) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

int_ret * runix_fsync_1_svc(int fd, struct svc_req *req)
{
	static int_ret  result;

	if((result.retcode = fsync(fd - FD_SHIFT)) == -1)
	  result.xerrno = enc_errno(errno);
	else
	  result.xerrno = 0;
	return (&result);
}  

