#include "runix.h"
#include "rpc/runix_prot.h"
#include "svc/runix_server.h"

/*
 * See comments in givefd.c
 */

#ifdef linux

int getfd(ulg handle)
{
  char buf[64];
  int fd;

  sprintf(buf, "/proc/%lu/fd/0", handle);
  
  if((fd = open(buf, O_RDWR)) == -1) return -1;
  
  /* Off it goes */
  kill((pid_t)handle, SIGKILL);
  return fd;
}

#else

#include <sys/socket.h>
#include <sys/un.h>

int getfd(ulg handle)
{
  int s, i, fd;
  static struct sockaddr_un un;
  static struct msghdr mhdr;
  struct iovec io;
  
#ifdef NEW_SENDMSG
  struct {
    struct cmsghdr cm;
    int fd;
  } x;
#endif

  if((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) return -1;

  un.sun_family = AF_UNIX;
  sprintf(un.sun_path, "/tmp/%lX", handle);

  /*
   * This happens inside a section delimited by sigprocmask(), so
   * it should never get EINTR
   */

  if(connect(s, &un, sizeof(un)) == -1) {
    close(s);
    return -1;
  }

  io.iov_base = &i;
  io.iov_len = sizeof(int);

  mhdr.msg_iov = &io;
  mhdr.msg_iovlen = 1;

#ifdef NEW_SENDMSG
  x.cm.cmsg_len = sizeof(x);
  x.cm.cmsg_level = SOL_SOCKET;
  x.cm.cmsg_type = SCM_RIGHTS;

  mhdr.msg_control = &x;
  mhdr.msg_controllen = sizeof(x);
#else
  mhdr.msg_accrights = &fd;
  mhdr.msg_accrightslen = sizeof(int);
#endif

  if(recvmsg(s, &mhdr, 0) == -1) {
    close(s);
    return -1;
  }
  
  close(s);

#ifdef NEW_SENDMSG
  return x.fd;
#else
  return fd;
#endif
}

#endif
