#include "runix.h"
#include "runixd/runixd.h"

#include <grp.h>

int setusercred(char *name)
{
  struct passwd *pw;
  struct group *gr;
  char *p, **q;

  gid_t sup[NGROUPS_MAX];
  int ngroups = 0;

  setgrent();
  while((gr = getgrent()) && ngroups < NGROUPS_MAX)
    for(q = gr -> gr_mem; p = *q; q++)
      if(!strcmp(p, name)) {
	sup[ngroups++] = gr -> gr_gid;
	break;
      }

  if(setgroups(ngroups, sup) == -1)
    return -1;

  if(!(pw = getpwnam(name)) ||
     setgid(pw -> pw_gid) == -1 ||
     setuid(pw -> pw_uid) == -1)
    return -1;

  return 0;
}

