#include "runix.h"
#include "net/net.h"
#include "runixd/runixd.h"

#include "rpc/runix_prot.h"

void *runix_prog_1();

void serve_client(int conn_s)
{
  SVCXPRT *svc;
  fd_set readfds;
  int i;

  if(!(svc = svcfd_create(conn_s, 0, 0))) {
    eprintf("svcfd_create");
    exit(-1);
  }

  if(svc_register(svc, RUNIX_PROG, RUNIX_VERS, runix_prog_1, 0) == FALSE) {
    eprintf("svc_register");
    exit(-1);
  }

  /*svc_run();*/
  for (;;) {
    readfds = svc_fdset;

    if(!FD_ISSET(conn_s, &readfds))
      exit(0);

    switch (select(FD_SETSIZE, &readfds, (int *)0, (int *)0,
		   (struct timeval *)0)) {
    case -1:
      if (errno == EINTR) {
	continue;
      }
      perror("svc_run: - select failed");
      return;
    case 0:
      continue;
    default:
      svc_getreqset(&readfds);
    }
  }
}
