#define MAIN

#include "runix.h"
#include "net/net.h"
#include "runixd/runixd.h"

#include <syslog.h>

extern char *optarg;
extern int optind, opterr;

static void zombie(void)
{
  while(waitpid(-1, NULL, WNOHANG|WUNTRACED) > 0);
}

main(int argc, char **argv)
{
  ush port = 0;
  unsigned t;
  int c;
  int s, fd;
  struct sockaddr_in peer;
  int peersize = sizeof(peer);
  char *p, *cookie_file = NULL;
  struct sigaction sa;

  uid  = getuid();
  euid = geteuid();

  Basename = (p = strrchr(argv[0], '/')) ? p+1 : argv[0];

  randomize();

  while((c = getopt(argc, argv, "p:dnf:")) != -1)
    switch(c) {
    case 'p':
      if(sscanf(optarg, "%u", &t) != 1) {
      usage:
	fputs("Usage: runixd [ -p port ] [-d] [-n] [-f cookie_file].\n", 
	      stderr);
      return -1;
      }
      port = htons(t);
      break;
    case 'd':
      debug = 1;
      break;
    case 'f':
      cookie_file = optarg;
    case 'n':
      nonpriv = 1;
    default:
      goto usage;
    }

  if(euid != uid && nonpriv) {
    setgid(getgid());
    setuid(uid);
  } else if(euid)
    nonpriv = 1;

  if(!debug) {
    openlog(Basename, LOG_CONS | LOG_PID, LOG_DAEMON);
    switch(fork()) {
    case -1:
      eprintf("fork: %m");
      return -1;
    case 0:
      break;
    default:
      return 0;
    }
    chdir("/");
    dup2(open("/dev/null", O_RDWR), 0);
    dup2(0, 1);
    dup2(0, 2);
    setsid();
  }

  if(nonpriv) {
    if(!cookie_file) {
      char *p = getenv("HOME");
      if(!p) {
	struct passwd *pw = getpwuid(uid);
	if(!pw) {
	  eprintf("Unable to find home directory for uid %u\n", uid);
	  return -1;
	}
	p = pw -> pw_dir;
      }
      cookie_file = malloc(strlen(p)+sizeof(cookie_name)+1);
      sprintf(cookie_file, "%s/%s", p, cookie_name);
    }

    if((fd = open(cookie_file, O_RDONLY)) < 0 ||
       read(fd, cookie, COOKIESIZE) != COOKIESIZE) {
      eprintf("%s: %m", cookie_file);
      return -1;
    }
    close(fd);
  }


  if(!port) {
    struct servent *se;
    if(!(se = getservbyname("runix", "tcp"))) {
      eprintf("runix: unknown service");
      return -1;
    }
    port = se -> s_port;
  }

  if((s = getport(INADDR_ANY, &port)) < 0) {
    eprintf("getport: %m");
    return -1;
  }

  if(!debug) {
    memset(&sa, 0, sizeof(sa));
    sa.sa_handler = zombie;
    sigemptyset(&sa.sa_mask);
    sigaddset(&sa.sa_mask, SIGCHLD);
    sigaddset(&sa.sa_mask, SIGALRM);
    sa.sa_flags = SA_RESTART;
    sigaction(SIGCHLD, &sa, NULL);
  }

  for(;;) {
    conn_s = accept(s, &peer, &peersize);
    if(conn_s == -1) {
      if(errno == EINTR) continue;
      eprintf("accept: %m");
      return -1;
    }

    if(!debug) {
      switch(fork()) {
      case -1:
	eprintf("fork: %m");
	break;
      case 0:
	close(s);
	sigaction(SIGCHLD, &sa, NULL);
	auth_client(conn_s, &peer);
	serve_client(conn_s);
	return 0;
      }
      close(conn_s);
    } else {
      auth_client(conn_s, &peer);
      serve_client(conn_s);
      return 0;
    }
  }
}

