#include "runix.h"
#include "net/net.h"
#include "runixd/runixd.h"

/*
 * Initial dialog doesn't use RPC. Why? Well it's nice to print some
 * readable string before conversation. Also I don't want to bother
 * declaring a separate protocol for authinication only. Well!
 * Fix it if you can...
 */

void auth_client(int s, struct sockaddr_in *addr)
{
  static char logname[LOGNAMESIZE], hercookie[COOKIESIZE], 
  		version[VERSIONSIZE];
  static uch proc;
  static struct iovec io[] = {{&proc, sizeof(proc)}, 
			      {logname, sizeof(logname)},
			      {hercookie, sizeof(cookie)}};
  struct passwd *pw;
  char c;
  int i;
  ulg vers;
  /*
   * Give her only so much time to fork() away the system.
   * Not that it matters.
   */
  if(!debug) alarm(AUTH_TIMEOUT);

  /*
   * Say hello.
   */

  sprintf(version, "%s%u", VERSIONPRFX, VERSION);
  i = strlen(version);
  memset(version + i, ' ', VERSIONSIZE-i-1);
  version[VERSIONSIZE-1] = '\n';
  write(s, version, VERSIONSIZE);

  /*
   * Now get client's version. If it's in future, say goodbye.
   */

  if(read(s, &vers, sizeof(vers)) != sizeof(vers))
    goto enet;
  vers = ntohl(vers);

  if(vers > VERSION) {
    c = AUTHERR_BADVERS; write(s, &c, 1);
    _exit(-1);
  }

  c = 0; write(s, &c, 1);

  /*
   * Get a bunch of info at once. Why not?
   */

  if(readv(s, io, sizeof(io)/sizeof(struct iovec)) !=
     sizeof(proc)+sizeof(logname)+sizeof(cookie)) {
  enet:;
    c = AUTHERR_NET; write(s, &c, 1);
    _exit(-1);
  }

  if(!debug) alarm(0);
  logname[LOGNAMESIZE-1] = '\0';

  if(!(pw = getpwnam(logname))) {
  badpass:;
    c = AUTHERR_BADPASS; write(s, &c, 1);
    _exit(-1);
  }

  /*
   * Look for cookie file AFTER dropping setuid. This
   * should make NFS happy.
   */

  if(chdir(pw -> pw_dir) < 0)
    goto badpass;

  if(nonpriv) {
    if(uid != pw->pw_uid)
      goto badpass;
  } else {
    int fd;
    if(setusercred(logname) < 0)
      goto badpass;
    if((fd = open(cookie_name, O_RDONLY)) < 0 ||
       read(fd, cookie, COOKIESIZE) != COOKIESIZE)
      goto badpass;
    close(fd);
  }
  if(memcmp(cookie, hercookie, COOKIESIZE))
    goto badpass;
  memset(cookie, 0, COOKIESIZE);
  memset(hercookie, 0, COOKIESIZE);

  switch(proc) {
  case PROC_INIT: 
    c = 0; write(s, &c, 1);
    break;

  case PROC_FORK:
    c = 0; write(s, &c, 1);
    givefd(s);
    _exit(0);

  default:
    c = AUTHERR_BADREQ; write(s, &c, 1);
  }
}
