/* -*- C -*- */
typedef string str<>;
typedef opaque opq<>;

enum unixerr {
  R_EWIRE = 0,		/* Problem with the server */
  R_EPERM,      	/* Operation not permitted */
  R_ENOENT,      	/* No such file or directory */
  R_ENOEXEC,            /* Exec format error */
  R_EBADF,              /* Bad file number */
  R_EACCES,             /* Permission denied */
  R_EEXIST,             /* File exists */
  R_EXDEV,	        /* Cross-device link */
  R_ENOTDIR,	        /* Not a directory */
  R_EISDIR,             /* Is a directory */
  R_ENOSPC,	        /* No space left on device */
  R_EROFS,	        /* Read-only file system */
  R_ENOTEMPTY,	        /* Directory not empty */
  R_ELOOP,	        /* Too many symbolic links encountered */
  R_EDQUOT		/* Quota exceeded */
};
 
const RO_RDONLY = 0;
const RO_WRONLY = 1;
const RO_RDWR   = 2;
const RO_EXCL   = 4;
const RO_CREAT  = 8;
const RO_TRUNC  = 16;
const RO_APPEND = 32;

const RR_OK = 1;
const RW_OK = 2;
const RX_OK = 4;
const RF_OK = 8;

enum file_types {
  RF_REG = 0x10000,
  RF_BLK = 0x20000,
  RF_CHR = 0x30000,
  RF_DIR = 0x40000,
  RF_SOC = 0x50000,
  RF_PIP = 0x60000,
  RF_SYM = 0x70000
};

enum rseek_method {
  RSEEK_SET = 0, 
  RSEEK_CUR,
  RSEEK_END
};

struct rstat {
  u_long xst_dev;
  u_long xst_ino;
  u_long xst_mode;
  u_long xst_nlink;
  long xst_uid;
  long xst_gid;
  u_long xst_size;
  u_long xst_blocks;
  u_long xst_atime;
  u_long xst_mtime;
  u_long xst_ctime;
};

struct rdirent {
  u_long d_fileno;
  opq d_name;
};

struct rutimbuf {
  u_long actime;
  u_long modtime;
};

typedef rutimbuf *rutimbufp;

struct int_ret {
  long retcode;
  int xerrno;
};
  
struct buf_ret {
  long retcode;
  opq buf;
  int xerrno;
};

struct str_ret {
  long retcode;
  str s;
  int xerrno;
};

struct stat_ret {
  long retcode;
  rstat st;
  int xerrno;
};


struct dir_ret {
  long retcode;
  rdirent dir<>;
  int xerrno;
};

program RUNIX_PROG {
  version RUNIX_VERS {
    int_ret   RUNIX_OPEN(str /*pathname */, int /*mode*/, int /*flags*/) = 1;
    buf_ret   RUNIX_READ(int /*fd*/, int /*count*/) = 2;
    int_ret   RUNIX_WRITE(int /*fd*/, opq /*buf*/, int /*count*/) = 3;
    int_ret   RUNIX_CLOSE(int /*fd*/) = 4;
    int_ret   RUNIX_LSEEK(int /*fd*/, long /*offset*/, int /*method */) = 5;
    /**/
    stat_ret  RUNIX_STAT(str /*pathname*/) = 6;
    stat_ret  RUNIX_LSTAT(str /*pathname*/) = 7;
    stat_ret  RUNIX_FSTAT(int /*fd*/) = 8;
    /**/
    int_ret   RUNIX_CHMOD(str /*path*/, int /*mode*/) = 9;
    int_ret   RUNIX_FCHMOD(int /*fd*/, int /*mode*/) = 10;
    int_ret   RUNIX_CHOWN(str /*path*/, long /*uid*/, long /*gid*/) = 11;
    int_ret   RUNIX_FCHOWN(int /*fd*/, long /*uid*/, long /*gid*/) = 12;
    int_ret   RUNIX_UMASK(int /*mask*/) = 13;
    /**/
    int_ret   RUNIX_MKDIR(str /*path*/, int mode) = 14;
    int_ret   RUNIX_CHDIR(str /*path*/) = 15;
    int_ret   RUNIX_RMDIR(str /*path*/) = 16;
    int_ret   RUNIX_FCHDIR(int /*fd*/) = 17;
    /**/
    int_ret   RUNIX_LINK(str /*old*/, str /*new*/) = 18;
    int_ret   RUNIX_UNLINK(str /*path*/) = 19;
    int_ret   RUNIX_RENAME(str /*old*/, str /*new*/) = 20;
    /**/
    int_ret   RUNIX_SYMLINK(str /*old*/, str /*new*/) = 21;
    buf_ret   RUNIX_READLINK(str /*path*/) = 22;
    /**/
    dir_ret   RUNIX_READDIR(str /*path */) = 23;
    /**/
    str_ret   RUNIX_GETWD(void) = 24;
    /**/
    int_ret   RUNIX_DUP(int /*fd*/) = 25;
    /**/
    int_ret   RUNIX_TRUNCATE(str/*path*/, long /*len*/) = 26;
    int_ret   RUNIX_FTRUNCATE(int /*fd*/, long /*len*/) = 27;
    /**/
    int_ret   RUNIX_FORK(u_long /*handle*/) = 28;
    /**/
    int_ret   RUNIX_UTIME(str /*path*/, rutimbufp /*buf*/) = 29;
    int_ret   RUNIX_MKNOD(str /*path*/, u_long /*mode*/, u_long /*dev*/) = 30;
    int_ret   RUNIX_ACCESS(str /*path*/, u_short /*mode*/) = 31;
    int_ret   RUNIX_FSYNC(int /*fd*/) = 32;
  } = 1;
} = 140000;

