#ifndef _PRELOAD_H
#define _PRELOAD_H

#ifndef DEBUG
#define disabled _runix_disabled
#define fdmap    _runix_fdmap
#define dirmap   _runix_dirmap
#define ndirs	 _runix_ndirs
#define dummyfd  _runix_dummyfd
#define crit	 _runix_crit
#define saved	 _runix_saved
#define remote   _runix_remote
#define statevar _runix_statevar
#endif

typedef struct dirtbl {
  DIR *dir;
  DIR *rdir;
} dirtbl;

int disabled;
int *fdmap;
dirtbl *dirmap;
int ndirs;

int dummyfd;
sigset_t crit, saved;
int remote;

char *statevar;

#ifdef DEBUG
/*
 * Try trapping infinite recursion.
 */
 
#define ird "runix: Infinite recursion detected!\n"

#define enter_critical() do { \
	if(!disabled) \
          sigprocmask(SIG_BLOCK, &crit, &saved); \
        if(++disabled > 128) { \
	  write(2, ird, sizeof(ird)-1); \
	  _exit(-1); \
        } \
      } while(0)

#else 

#define enter_critical() \
	if(!disabled) { \
	  sigprocmask(SIG_BLOCK, &crit, &saved); \
	  disabled = 1; \
	} else 

#endif

#define leave_critical() \
	if(disabled) { \
	  disabled = 0; \
	  sigprocmask(SIG_SETMASK, &saved, NULL); \
        } else

#define isremote(path) (((path)[0] == '/') && ((path)[1] == '@') && \
			((path)[2] == '/'))
			
#define islocal(path)  (((path)[0] == '/') && \
			(((path)[1] != '@') || ((path)[2] != '/')))

#define isremfd(fd) (fdmap[(fd)] > 0)

#define doremote(path) (isremote(path) || (remote && !islocal(path)))

#define pathdup(path) (isremote(path) ? ((path)+2) : (path))

#define chk_fd(fd) do { \
   if((fd) < 0 || (fd) >= dummyfd) { \
     errno = EBADF; \
     return -1; \
   } \
 } while(0)

#define chk_path(path) do { \
   if(!(path)) { \
     errno = EFAULT; \
     return -1; \
   } \
   if(!*(path)) \
     (path) = "."; \
   else if((path)[0] == '/' && (path)[1] == '@' && !(path)[2]) \
     (path) = "/@/"; \
 } while(0)

#define chk_buf(buf) do { \
  if(!(buf)) { \
    errno = EFAULT; \
    return -1; \
  } \
 } while(0)

#define hide_errno(e) \
  do { \
    int _hide_errno = errno; \
    (e); \
    errno = _hide_errno; \
  } while(0)

#endif

