#include "runix.h"

#include "preload/c_runix.h"
#include "preload/preload.h"
#include "preload/dlconfig.h"

#ifdef ADD_LIBC_ALT_PREFIX

#define STUB(f,F,p) \
F##_RET f F##_P##p \
{ \
   F##_RET result; \
   \
   if(disabled) \
     return c_##f##p; \
   \
   LIB_INIT(); \
   \
   enter_critical(); \
   result = i_##f##p; \
   leave_critical(); \
   return result; \
} \
\
F##_RET ADD_LIBC_ALT_PREFIX(f) F##_P##p \
{ \
   return f##p; \
}


/*
 * And for void functions:
 */

#define VSTUB(f,F,p) \
F##_RET f F##_P##p \
{ \
   if(disabled) { \
     c_##f##p; \
     return; \
   } \
   \
   LIB_INIT(); \
   \
   enter_critical(); \
   i_##f##p; \
   leave_critical(); \
} \
\
F##_RET ADD_LIBC_ALT_PREFIX(f) F##_P##p \
{ \
  f##p; \
}

#else

#define STUB(f,F,p) \
F##_RET f F##_P##p \
{ \
   F##_RET result; \
   \
   if(disabled) \
     return c_##f##p; \
   \
   LIB_INIT(); \
   \
   enter_critical(); \
   result = i_##f##p; \
   leave_critical(); \
   return result; \
}

/*
 * And for void functions:
 */

#define VSTUB(f,F,p) \
F##_RET f F##_P##p \
{ \
   if(disabled) { \
     c_##f##p; \
     return; \
   } \
   \
   LIB_INIT(); \
   \
   enter_critical(); \
   i_##f##p; \
   leave_critical(); \
}

#endif /* ADD_LIBC_ALT_PREFIX */

/*
 * Appears to be a special case.
 */

OPEN_RET
open OPEN_P(file, flags)
{
  int result;
  va_list va;
  int mode;

  va_start(va, flags);
  mode = (flags & O_CREAT) ? va_arg(va, int) : 0666;
  va_end(va);
  
  if (disabled)
    return c_open (file, flags, mode);

  LIB_INIT();
  enter_critical();

  result = i_open (file, flags, mode);

  leave_critical();
  return result;
}

#ifdef ADD_LIBC_ALT_PREFIX
OPEN_RET ADD_LIBC_ALT_PREFIX(open) OPEN_P(file, flags)
{
  va_list va;
  int mode;
  
  va_start(va, flags);
  mode = (flags & O_CREAT) ? va_arg(va, int) : 0666;
  va_end(va);
  return open(file, flags, mode);
}
#endif
STUB(creat,CREAT,(file, mode))
STUB(read,READ,(fd, buf, count))
STUB(write,WRITE,(fd, buf, count))
STUB(close,CLOSE,(fd))
STUB(lseek,LSEEK,(fd, offset, whence))


#ifdef linux

STUB(_fxstat, _FXSTAT, (ver, fd, buf));
STUB(_xstat,  _XSTAT, (ver, file, buf));
STUB(_lxstat, _LXSTAT, (ver, file, buf));
STUB(_xmknod, _XMKNOD, (ver, file, mode, dev));
VSTUB(exit, EXIT, (ret));

#else

STUB(stat,STAT,(file, st))
STUB(fstat,FSTAT,(fd, st))
STUB(lstat,LSTAT,(file, st))
STUB(mknod,MKNOD,(path, mode, dev));

#endif

STUB(chmod,CHMOD,(path, mode))
STUB(fchmod,FCHMOD,(fd, mode))
STUB(chown,CHOWN,(path, uid, gid))
STUB(fchown,FCHOWN,(fd, uid, gid))
STUB(umask,UMASK,(mask))
STUB(mkdir,MKDIR,(path, mode))
STUB(chdir,CHDIR,(path))
STUB(rmdir,RMDIR,(path))
STUB(fchdir,FCHDIR,(fd))
STUB(link,LINK,(old, new))
STUB(unlink,UNLINK,(path))
STUB(rename,RENAME,(old, new))
STUB(symlink,SYMLINK,(old, new))
STUB(readlink,READLINK,(path, buf, bufsiz))
STUB(getcwd,GETCWD,(buf, size))
STUB(getwd,GETWD,(buf))
STUB(dup,DUP,(fd))
STUB(dup2,DUP2,(old, new))
STUB(truncate,TRUNCATE,(path, len))
STUB(ftruncate,FTRUNCATE,(fd, len))
STUB(scandir,SCANDIR,(dir, namelist, select, compar))
STUB(opendir,OPENDIR,(name))
STUB(readdir,READDIR,(dir))
STUB(closedir,CLOSEDIR,(dir))
VSTUB(seekdir,SEEKDIR,(dir, offset))
VSTUB(rewinddir,REWINDDIR,(dir))
STUB(telldir,TELLDIR,(dir))

STUB(execve,EXECVE,(file, argv, envp))
STUB(execvp,EXECVP,(file, argv))
STUB(execv,EXECV,(file,argv))

STUB(fork,FORK,())
STUB(vfork,VFORK,())
STUB(utime,UTIME,(path,buf));
STUB(access, ACCESS, (path, mode));
STUB(mmap, MMAP, (addr, len, prot, flags, fd, offset));

STUB(readv, READV, (fd, vec, cnt));
STUB(writev, WRITEV, (fd, vec, cnt));

STUB(fsync, FSYNC, (fd));

#define _c2v(va, argv, arg) \
do { \
  int _c2v_argc, _c2v_i; \
\
  va_start(va, arg); \
  for(_c2v_argc = 1; va_arg(va, char *); _c2v_argc++); \
  va_end(va); \
\
  argv = alloca((_c2v_argc+1)*sizeof(char *)); \
  argv[0] = arg; \
\
  va_start(va, arg); \
  for(_c2v_i = 1; _c2v_i < _c2v_argc; _c2v_i++) \
    argv[_c2v_i] = va_arg(va, char *); \
  argv[_c2v_i] = NULL; \
} while(0)


#define c2v(argv, arg) \
do { \
  va_list _c2v_va; \
  _c2v(_c2v_va, argv, arg); \
  va_end(_c2v_va); \
} while(0)

#define c2ve(argv, envp, arg) \
do { \
  va_list _c2v_va; \
  _c2v(_c2v_va, argv, arg); \
  va_arg(_c2v_va, char *); \
  envp = va_arg(_c2v_va, char **); \
  va_end(_c2v_va); \
} while(0)

EXECL_RET execl EXECL_P(path, arg)
{
  char **argv;
  c2v(argv, arg);
  return execv(path, argv);
}

EXECLP_RET execlp EXECLP_P(path, arg)
{
  char **argv;
  c2v(argv, arg);
  return execvp(path, argv);
}

EXECLE_RET execle EXECLE_P(path, arg)
{
  char **argv, **envp;
  c2ve(argv, envp, arg);
  return execve(path, argv, envp);
}

#ifdef ADD_LIBC_ALT_PREFIX
EXECL_RET ADD_LIBC_ALT_PREFIX(execl) EXECL_P(path, arg)
{
  char **argv;
  c2v(argv, arg);
  return execv(path, argv);
}

EXECLP_RET ADD_LIBC_ALT_PREFIX(execlp) EXECLP_P(path, arg)
{
  char **argv;
  c2v(argv, arg);
  return execvp(path, argv);
}

EXECLE_RET ADD_LIBC_ALT_PREFIX(execle) EXECLE_P(path, arg)
{
  char **argv, **envp;
  c2ve(argv, envp, arg);
  return execve(path, argv, envp);
}

#endif

UTIMES_RET utimes UTIMES_P(path, tvp)
{
  if(!tvp)
    return utime(path, NULL);
  else {
    struct utimbuf ut;
    ut.actime = tvp[0].tv_sec;
    ut.modtime = tvp[1].tv_sec;
    return utime(path, &ut);
  }
}

#ifdef ADD_LIBC_ALT_PREFIX
UTIMES_RET ADD_LIBC_ALT_PREFIX(utimes) UTIMES_P(path, tvp)
{
  return utimes(path, tvp);
}
#endif
