#define MAIN
#include "runix.h"
#include "rpc/runix_prot.h"

/*
 * :(
 */
#undef GLOBAL
#undef IS
#define GLOBAL extern
#define IS(x) 
#include "clnt/runixlib.h"
#undef GLOBAL
#undef IS
#define GLOBAL
#define IS(x) = (x)

#include "preload/c_runix.h"
#include "preload/preload.h"
#include "preload/dlconfig.h"

#include <sys/socket.h>

#define getsym(s) \
	if(!(c_##s = dlsym(libc, #s))) { \
	  kill(getpid(), 9); \
        } else

LIB_INITFUNC()
{
  void *libc;
  char *state;

  OPEN_LIBC(libc);

  getsym(open); getsym(creat); getsym(read); getsym(write); getsym(close);
  getsym(lseek); 
#ifdef linux
  getsym(_xstat); getsym(_fxstat); getsym(_lxstat); getsym(_xmknod); 
  getsym(exit);
#else
  getsym(stat); getsym(fstat); getsym(lstat); getsym(mknod);
#endif
  getsym(chmod);
  getsym(fchmod); getsym(chown); getsym(fchown); getsym(umask); getsym(mkdir);
  getsym(chdir); getsym(rmdir); getsym(fchdir); getsym(link); getsym(unlink);
  getsym(rename); getsym(symlink); getsym(readlink); getsym(getcwd);
  getsym(getwd); getsym(dup); getsym(dup2); getsym(truncate); 
  getsym(ftruncate); getsym(scandir); getsym(opendir); getsym(readdir);
  getsym(closedir); getsym(seekdir); getsym(rewinddir); getsym(telldir);
  getsym(execve); getsym(execvp); getsym(execv);
  getsym(fork); getsym(vfork); getsym(utime); getsym(access); getsym(mmap);
  getsym(readv); getsym(writev); getsym(fsync); 

  disabled = 1;

  if(state = getenv("RUNIX_STATE")) {
    char *p, *State;
    int i;
    static struct sockaddr_in notme = { AF_INET };
    
    /*
     * Handle programs exec*()'d by a process that uses runix as well.
     * In this case, connection to the server and some remote files may
     * be already open, so we just pick them up from an environment
     * variable.
     */
    
    State = state = Strdup(state);
    /* 
     * Can't use strtok as user program could as well. Ok, we must
     * use getpwent(), but it's still good to disrupt libc state as little
     * as possible.
     */
    if(!(p = strchr(state, ':')) || (*p = '\0', atoi(state) != getpid())) {
      free(State);
      goto nostate;
    }
    /*
     * Decide to trust the environment variable from now on.
     */

    Basename = "runixlib";
    debug = 1;
    
    state = p+1; p = strchr(state, ':'); *p = '\0';
    rpc_fd = atoi(state);

    state = p+1; p = strchr(state, ':'); *p = '\0';
    remote = atoi(state);
    
    notme.sin_port = 1;
    notme.sin_addr.s_addr = INADDR_LOOPBACK;
    
    if(!(clnt = clnttcp_create(&notme, RUNIX_PROG, RUNIX_VERS, &rpc_fd,
			       0, 0))) {
      eprintf(clnt_spcreateerror("clnttcp_create"));
      close(rpc_fd);
      _exit(125);
    } 

    dummyfd = rpc_fd - 1;
    
    fdmap = Malloc(dummyfd * sizeof(int));
    dirmap = Malloc(dummyfd * sizeof(dirtbl));
    memset(fdmap, 0, dummyfd * sizeof(int));
    memset(dirmap, 0, dummyfd * sizeof(dirtbl));
    
    for(i = 0 ; i < dummyfd; i++) {
      state = p+1; p = strchr(state, ':'); if(p) *p = '\0';
      fdmap[i] = atoi(state);
    }
      
    free(State);
  } else {
  nostate:;
    
    if(r_runixinit(NULL) != 0)
      _exit(125);
    
    /*
     * This is a bit bizzare, and, like code in r_runixinit, relies on existance
     * of a reasonably small system limit on number of open descriptors. Well,
     * enjoy!
     */

    {
      struct rlimit rl;
      int pcur;
      int xfd = socket(AF_INET,SOCK_STREAM,0);
      
      dummyfd = rpc_fd - 1;
      
      getrlimit(RLIMIT_NOFILE, &rl);
      pcur = rl.rlim_cur;
      rl.rlim_cur = rl.rlim_max;
      setrlimit(RLIMIT_NOFILE, &rl);
      
      if(xfd == -1) {
	eprintf("socket: %m");
	_exit(124);
      }
      
      if(dup2(xfd, dummyfd) == -1) {
	eprintf("dup2: %m");
	_exit(124);
      }
      
      close(xfd);
      rl.rlim_cur = (pcur > dummyfd) ? pcur - 1 : pcur;
      setrlimit(RLIMIT_NOFILE, &rl);
    }
    fdmap = Malloc(dummyfd * sizeof(int));
    dirmap = Malloc(dummyfd * sizeof(dirtbl));
    memset(fdmap, 0, dummyfd * sizeof(int));
    memset(dirmap, 0, dummyfd * sizeof(dirtbl));
  }
  
  statevar = Malloc((dummyfd+2)*11+32);

  sigemptyset(&crit);
#ifdef SIGHUP
  sigaddset(&crit, SIGHUP);
#endif
#ifdef SIGINT
  sigaddset(&crit, SIGINT);
#endif
#ifdef SIGQUIT
  sigaddset(&crit, SIGQUIT);
#endif
#ifdef SIGPIPE
  sigaddset(&crit, SIGPIPE);
#endif
#ifdef SIGALRM
  sigaddset(&crit, SIGALRM);
#endif
#ifdef SIGCHLD
  sigaddset(&crit, SIGCHLD);
#endif
#ifdef SIGTSTP
  sigaddset(&crit, SIGTSTP);
#endif
#ifdef SIGCONT
  sigaddset(&crit, SIGCONT);
#endif
#ifdef SIGTTIN
  sigaddset(&crit, SIGTTIN);
#endif
#ifdef SIGTTOU
  sigaddset(&crit, SIGTTOU);
#endif
#ifdef SIGURG
  sigaddset(&crit, SIGURG);
#endif
#ifdef SIGWINCH
  sigaddset(&crit, SIGWINCH);
#endif
#ifdef SIGIO
  sigaddset(&crit, SIGIO);
#endif
#ifdef SIGPOLL
  sigaddset(&crit, SIGPOLL);
#endif

  {
    UMASK_RET um;
    r_umask(um = c_umask(0));
    c_umask(um);
  }
  disabled = 0;
  errno = 0;
}
