#include "runix.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"
#include "preload/c_runix.h"
#include "preload/preload.h"

static void mkstatevar(void)
{
  int i,l;

  sprintf(statevar, "RUNIX_STATE=%u:%u:%u", getpid(), dummyfd+1, remote);
  
  l = strlen(statevar);

  for(i = 0; i < dummyfd; i++) {
    sprintf(statevar+l, ":%u", fdmap[i]);
    l += strlen(statevar+l);
  }
}

EXECVE_RET i_execve EXECVE_P(path, argv, envp)
{
  int len, i;
  char **env;
  char *p;

  chk_path(path);
  chk_buf(argv);
  chk_buf(envp);

  if(doremote(path)) {
    /*
     * Remote execution not implemented (yet).
     */
    errno = ENOSYS;
    return -1;
  }

  mkstatevar();
  
  i = -1;
  for(env = envp, len = 0; p = *env; len++, env++)
    if(i == -1 && !strncmp(p, "RUNIX_STATE=", sizeof("RUNIX_STATE=")-1))
      i = len;
  
  env = alloca((len+2)*sizeof(char *));
  memcpy(env, envp, len*sizeof(char *));
  
  if(i < 0) {
    env[len] = statevar;
    env[len+1] = NULL;
  } else {
    env[i] = statevar;
    env[len] = NULL;
  }

  leave_critical();
  return c_execve(path, argv, env);
}

EXECVP_RET i_execvp EXECVP_P(path, argv)
{
  chk_path(path);
  chk_buf(argv);

  if(doremote(path)) {
    /*
     * Remote execution not implemented (yet).
     */
    errno = ENOSYS;
    return -1;
  }

  mkstatevar();
  putenv(statevar);
  leave_critical();
  return c_execvp(path, argv);
}

EXECV_RET i_execv EXECV_P(path, argv)
{
  chk_path(path);
  chk_buf(argv);

  if(doremote(path)) {
    /*
     * Remote execution not implemented (yet).
     */
    errno = ENOSYS;
    return -1;
  }

  mkstatevar();
  putenv(statevar);
  leave_critical();
  return c_execv(path, argv);
}


