#include "runix.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"
#include "preload/c_runix.h"
#include "preload/preload.h"

static DIR *isremdir(DIR *d)
{
  int i;
  for(i = 0; i < ndirs; i++)
    if(dirmap[i].dir == d)
      return dirmap[i].rdir;
  return NULL;
}

OPENDIR_RET i_opendir OPENDIR_P(path)
{
  OPENDIR_RET ret;

  if(!path) {
    errno = EFAULT;
    return NULL;
  }

  if(!*path)
    path = ".";
  else if(path[0] == '/' && path[1] == '@' && !path[2])
    path = "/@/";
    
  if(!doremote(path))
    return c_opendir(pathdup(path));

  if(!(ret = opendir("/tmp")))
    return NULL;
  
  dirmap[ndirs].dir = ret;

  if(!(dirmap[ndirs].rdir = r_opendir(pathdup(path)))) {
    closedir(ret);
    return NULL;
  }

  ndirs++;
  return ret;
}

SCANDIR_RET i_scandir SCANDIR_P(path, namelist, select, compar)
{
  chk_path(path);
  chk_buf(namelist);
  
  return doremote(path) ? r_scandir(pathdup(path), namelist, select, compar) :
    c_scandir(path, namelist, select, compar);
}

READDIR_RET i_readdir READDIR_P(dir)
{
  dir_ret *r;

  if(!dir) {
    errno = EFAULT;
    return NULL;
  }
  
  return (r = isremdir(dir)) ? r_readdir(r) :
    c_readdir(dir);
}

CLOSEDIR_RET i_closedir CLOSEDIR_P(dir)
{
  CLOSEDIR_RET ret;
  int i;

  chk_buf(dir);

  for(i = 0; i < ndirs; i++)
    if(dirmap[i].dir == dir) {
      c_closedir(dir);
      ret = r_closedir(dirmap[i].rdir);
      dirmap[i] = dirmap[ndirs-1];
      ndirs--;
      return ret;
    }

  return c_closedir(dir);
}

SEEKDIR_RET i_seekdir SEEKDIR_P(dir, offset)
{
  dir_ret *r;

  (r = isremdir(dir)) ? r_seekdir(r, offset) : 
    c_seekdir(dir, offset);
}

REWINDDIR_RET i_rewinddir REWINDDIR_P(dir)
{
  dir_ret *r;

  (r = isremdir(dir)) ? r_rewinddir(r) :
    c_rewinddir(dir);
}

TELLDIR_RET i_telldir TELLDIR_P(dir)
{
  dir_ret *r;

  chk_buf(dir);
  return (r = isremdir(dir)) ? r_telldir(r) : 
    c_telldir(dir);
}


