#ifndef _DLCONFIG_H
#define _DLCONFIG_H

/*
 * Describe dynamic linking on your system.
 */

/*
 * You'll have to change this for systems that are not SunOS,
 * Solaris or Linux.
 */

/*
 * Header file needed to get dlopen and friends.
 */

#include <dlfcn.h>

/*
 * How to get lazy binding. Should be in the above header file, but
 * is not documented while the underlying constant (1) is.
 */

#ifndef RTLD_LAZY
#	define RTLD_LAZY 1
#endif

/*
 * How to dlopen libc. If dlopen doesn't search LD_LIBRARY_PATH itself, there is
 * hardly a portable way to do it. Therefore, under SunOS 4.x  you must make a 
 * symbolic link called /lib/_libc_so to point it in the right direction 
 * (if you are not root, you may want to use something like 
 * /home/snowcat/lib/_libc_so)
 *
 * Under Solaris 2.x, no dlopen is necessary as RTLD_NEXT can be used to access
 * symbols instead.
 */

#ifndef OPEN_LIBC

#ifdef linux
	/*
	 * Under Linux ld.so 1.7.4, RTLD_NEXT is not supported and dlopen("libc.so",...)
	 * triggers the whole series of ld.so bugs. The following code finds existing handle
	 * for libc created at program startup. It uses ld.so internals that can change at
	 * any time, but I hope next time they change, you'll be able to use the code below
	 * or RTLD_NEXT
	 */

struct xdyn_elf {
  struct xelf_resolve *dyn;
  struct xdyn_elf *next_handle;
  struct xdyn_elf *next;
};

struct xelf_resolve {
  char *loadaddr;
  char *libname;
  /*
   * There is more, but that's all we care about :)
   */
};

extern struct xdyn_elf *_dl_symbol_tables;

static void _runix_open_libc(void **handle)
{
  struct xdyn_elf *h;
  char *p;
  
  for(h = _dl_symbol_tables; h; h = h -> next)
    if(h -> dyn && (p = h -> dyn -> libname) && 
       (!strncmp(p, "libc.so.", sizeof("libc.so.")-1) ||
	strstr(p, "/libc.so.")))
      break;
  
  if(!h) 
    kill(getpid(), 9);
  
  *handle = h;
}

#define OPEN_LIBC(handle) (_runix_open_libc(&(handle)))

#ifdef NO_LINUX_LDSO_BUGS
#	define OPEN_LIBC(handle) \
	  if(!((handle) = dlopen("libc.so", RTLD_LAZY))) \
	    kill(getpid(), 9); \
          else
#endif

#elif defined(sunos4)
#	define OPEN_LIBC(handle) \
	  if(!((handle) = dlopen("/lib/_libc_so", RTLD_LAZY))) \
	    kill(getpid(), 9); \
          else
#else
#	define OPEN_LIBC(handle) ((handle) = RTLD_NEXT)
#endif

#endif

/*
 * How to declare a function that will be automagically called to initialize
 * LD_PRELOAD'ed object. If there is no such luck, define LIB_INIT to be called
 * on invocation of any function in the library.
 *
 * __attribute__(constructor) is specific to gcc 2.7.x+ 
 */

#ifndef LIB_INIT

#if defined(DEBUG) || defined(sunos4)
	int _librunix_initdone;	     
#	define LIB_INIT() do { \
		if(!_librunix_initdone) { \
		  _librunix_init(); \
		  _librunix_initdone++; \
		} \
	     } while(0)
#	define LIB_INITFUNC() void _librunix_init(void)
#else
#	define LIB_INIT()
#	define LIB_INITFUNC() \
	   static void _librunix_init(void) __attribute__((constructor)); \
	   static void _librunix_init(void)
#endif

#endif

/*
 * An alternative prefix for libc functions. For example, if it's
 * __, generate __open in addition to open.
 */

#if !defined(ADD_LIBC_ALT_PREFIX) && !defined(NO_ADD_LIBC_ALT_PREFIX)

#if defined(sunos4)
#	undef ADD_LIBC_ALT_PREFIX
#elif defined(linux) 
#	define ADD_LIBC_ALT_PREFIX(x) __##x
#else
#	define ADD_LIBC_ALT_PREFIX(x) _##x
#endif

#endif

#endif
