#ifndef _C_RUNIX_H
#define _C_RUNIX_H

#include "ansiprot.h"

/*
 * runix interface to C library
 */

#ifndef DEBUG
#define c_open _runix_c_open
#define c_creat _runix_c_creat
#define c_read _runix_c_read
#define c_write _runix_c_write
#define c_close _runix_c_close
#define c_lseek _runix_c_lseek

#ifdef linux
#	define c__xstat  _runix_c__xstat
#	define c__fxstat _runix_c__fxstat
#	define c__lxstat _runix_c__lxstat
#	define c__xmknod _runix_c__xmknod
#	define c_exit    _runix_c_exit
#else
#	define c_stat _runix_c_stat
#	define c_fstat _runix_c_fstat
#	define c_lstat _runix_c_lstat
#	define c_mknod _runix_c_mknod
#endif

#define c_chmod _runix_c_chmod
#define c_fchmod _runix_c_fchmod
#define c_chown _runix_c_chown
#define c_fchown _runix_c_fchown
#define c_umask _runix_c_umask
#define c_mkdir _runix_c_mkdir
#define c_chdir _runix_c_chdir
#define c_rmdir _runix_c_rmdir
#define c_fchdir _runix_c_fchdir
#define c_link _runix_c_link
#define c_unlink _runix_c_unlink
#define c_rename _runix_c_rename
#define c_symlink _runix_c_symlink
#define c_readlink _runix_c_readlink
#define c_getcwd _runix_c_getcwd
#define c_getwd _runix_c_getwd
#define c_dup _runix_c_dup
#define c_dup2 _runix_c_dup2
#define c_truncate _runix_c_truncate
#define c_ftruncate _runix_c_ftruncate
#define c_scandir _runix_c_scandir
#define c_opendir _runix_c_opendir
#define c_readdir _runix_c_readdir
#define c_closedir _runix_c_closedir
#define c_seekdir _runix_c_seekdir
#define c_rewinddir _runix_c_rewinddir
#define c_telldir _runix_c_telldir
#define c_execve _runix_c_execve
#define c_execvp _runix_c_execvp
#define c_execv  _runix_c_execv
#define c_fork _runix_c_fork
#define c_vfork _runix_c_vfork
#define c_utime _runix_c_utime
#define c_access _runix_c_access
#define c_mmap _runix_c_mmap
#define c_readv _runix_c_readv
#define c_writev _runix_c_writev
#define c_fsync _runix_c_fsync
#endif

OPEN_RET (*c_open) OPEN_P(file, flags);
CREAT_RET (*c_creat) CREAT_P(file, mode);
READ_RET (*c_read) READ_P(fd, buf, count);
WRITE_RET (*c_write) WRITE_P(fd, buf, count);
CLOSE_RET (*c_close) CLOSE_P(fd);
LSEEK_RET (*c_lseek) LSEEK_P(fd, offset, whence);

#ifdef linux
_FXSTAT_RET (*c__fxstat) _FXSTAT_P(ver, fd, st);
_LXSTAT_RET (*c__lxstat) _LXSTAT_P(ver, file, st);
_XSTAT_RET  (*c__xstat)  _XSTAT_P(ver, file, st);
_XMKNOD_RET (*c__xmknod) _XMKNOD_P(ver, file, mode, dev);
EXIT_RET (*c_exit) EXIT_P(ret);
#else
FSTAT_RET (*c_fstat) FSTAT_P(fd, st);
LSTAT_RET (*c_lstat) LSTAT_P(file, st);
STAT_RET (*c_stat) STAT_P(file, st);
MKNOD_RET (*c_mknod) MKNOD_P(path, mode, dev);
#endif

CHMOD_RET (*c_chmod) CHMOD_P(path, mode);
FCHMOD_RET (*c_fchmod) FCHMOD_P(fd, mode);
CHOWN_RET (*c_chown) CHOWN_P(path, uid, gid);
FCHOWN_RET (*c_fchown) FCHOWN_P(fd, uid, gid);
UMASK_RET (*c_umask) UMASK_P(mask);
MKDIR_RET (*c_mkdir) MKDIR_P(path, mode);
CHDIR_RET (*c_chdir) CHDIR_P(path);
RMDIR_RET (*c_rmdir) RMDIR_P(path);
FCHDIR_RET (*c_fchdir) FCHDIR_P(fd);
LINK_RET (*c_link) LINK_P(old, new);
UNLINK_RET (*c_unlink) UNLINK_P(path);
RENAME_RET (*c_rename) RENAME_P(old, new);
SYMLINK_RET (*c_symlink) SYMLINK_P(old, new);
READLINK_RET (*c_readlink) READLINK_P(path, buf, bufsiz);
GETCWD_RET (*c_getcwd) GETCWD_P(buf, size);
GETWD_RET (*c_getwd) GETWD_P(buf);
DUP_RET (*c_dup) DUP_P(fd);
DUP2_RET (*c_dup2) DUP2_P(old, new);
TRUNCATE_RET (*c_truncate) TRUNCATE_P(path, len);
FTRUNCATE_RET (*c_ftruncate) FTRUNCATE_P(fd, len);
SCANDIR_RET (*c_scandir) SCANDIR_P(dir, namelist, select, compar);
OPENDIR_RET (*c_opendir) OPENDIR_P(name);
READDIR_RET (*c_readdir) READDIR_P(dir);
CLOSEDIR_RET (*c_closedir) CLOSEDIR_P(dir);
SEEKDIR_RET (*c_seekdir) SEEKDIR_P(dir, offset);
REWINDDIR_RET (*c_rewinddir) REWINDDIR_P(dir);
TELLDIR_RET (*c_telldir) TELLDIR_P(dir);

EXECVE_RET (*c_execve) EXECVE_P(file, argv, envp);
EXECVP_RET (*c_execvp) EXECVP_P(path, argv);
EXECV_RET  (*c_execv)  EXECV_P(path, argv);

FORK_RET  (*c_fork) FORK_P();
VFORK_RET (*c_vfork) VFORK_P();

UTIME_RET (*c_utime) UTIME_P(path, buf);
ACCESS_RET (*c_access) ACCESS_P(path, mode);
MMAP_RET (*c_mmap) MMAP_P(addr, len, prot, flags, fd, offset);

READV_RET (*c_readv) READV_P(fd, vec, cnt);
WRITEV_RET (*c_writev) WRITEV_P(fd, vec, cnt);

FSYNC_RET (*c_fsync) FSYNC_P(fd);

/*
 * i-functions - direct interface to remote procedures.
 */
#ifndef DEBUG
#define i_open _runix_i_open
#define i_creat _runix_i_creat
#define i_read _runix_i_read
#define i_write _runix_i_write
#define i_close _runix_i_close
#define i_lseek _runix_i_lseek

#ifdef linux
#	define i__xstat  _runix_i__xstat
#	define i__fxstat _runix_i__fxstat
#	define i__lxstat _runix_i__lxstat
#	define i__xmknod _runix_i__xmknod
#	define i_exit	 _runix_i_exit
#else
#	define i_stat _runix_i_stat
#	define i_fstat _runix_i_fstat
#	define i_lstat _runix_i_lstat
#	define i_mknod _runix_i_mknod
#endif

#define i_chmod _runix_i_chmod
#define i_fchmod _runix_i_fchmod
#define i_chown _runix_i_chown
#define i_fchown _runix_i_fchown
#define i_umask _runix_i_umask
#define i_mkdir _runix_i_mkdir
#define i_chdir _runix_i_chdir
#define i_rmdir _runix_i_rmdir
#define i_fchdir _runix_i_fchdir
#define i_link _runix_i_link
#define i_unlink _runix_i_unlink
#define i_rename _runix_i_rename
#define i_symlink _runix_i_symlink
#define i_readlink _runix_i_readlink
#define i_getcwd _runix_i_getcwd
#define i_getwd _runix_i_getwd
#define i_dup _runix_i_dup
#define i_dup2 _runix_i_dup2
#define i_truncate _runix_i_truncate
#define i_ftruncate _runix_i_ftruncate
#define i_scandir _runix_i_scandir
#define i_opendir _runix_i_opendir
#define i_readdir _runix_i_readdir
#define i_closedir _runix_i_closedir
#define i_seekdir _runix_i_seekdir
#define i_rewinddir _runix_i_rewinddir
#define i_telldir _runix_i_telldir
#define i_execve _runix_i_execve
#define i_execvp _runix_i_execvp
#define i_execv  _runix_i_execv
#define i_fork _runix_i_fork
#define i_vfork _runix_i_vfork
#define i_utime _runix_i_utime
#define i_access _runix_i_access
#define i_mmap _runix_i_mmap
#define i_readv _runix_i_readv
#define i_writev _runix_i_writev
#define i_fsync _runix_i_fsync
#endif

OPEN_RET i_open OPEN_P(file, flags);
CREAT_RET i_creat CREAT_P(file, mode);
READ_RET i_read READ_P(fd, buf, count);
WRITE_RET i_write WRITE_P(fd, buf, count);
CLOSE_RET i_close CLOSE_P(fd);
LSEEK_RET i_lseek LSEEK_P(fd, offset, whence);

#ifdef linux
_XSTAT_RET i__xstat _XSTAT_P(ver, file, st);
_FXSTAT_RET i__fxstat _FXSTAT_P(ver, fd, st);
_LXSTAT_RET i__lxstat _LXSTAT_P(ver, file, st);
_XMKNOD_RET i__xmknod _XMKNOD_P(ver, file, mode, dev);
EXIT_RET i_exit EXIT_P(ret);
#else
STAT_RET i_stat STAT_P(file, st);
FSTAT_RET i_fstat FSTAT_P(fd, st);
LSTAT_RET i_lstat LSTAT_P(file, st);
MKNOD_RET i_mknod MKNOD_P(path, mode, dev);
#endif

CHMOD_RET i_chmod CHMOD_P(path, mode);
FCHMOD_RET i_fchmod FCHMOD_P(fd, mode);
CHOWN_RET i_chown CHOWN_P(path, uid, gid);
FCHOWN_RET i_fchown FCHOWN_P(fd, uid, gid);
UMASK_RET i_umask UMASK_P(mask);
MKDIR_RET i_mkdir MKDIR_P(path, mode);
CHDIR_RET i_chdir CHDIR_P(path);
RMDIR_RET i_rmdir RMDIR_P(path);
FCHDIR_RET i_fchdir FCHDIR_P(fd);
LINK_RET i_link LINK_P(old, new);
UNLINK_RET i_unlink UNLINK_P(path);
RENAME_RET i_rename RENAME_P(old, new);
SYMLINK_RET i_symlink SYMLINK_P(old, new);
READLINK_RET i_readlink READLINK_P(path, buf, bufsiz);
GETCWD_RET i_getcwd GETCWD_P(buf, size);
GETWD_RET i_getwd GETWD_P(buf);
DUP_RET i_dup DUP_P(fd);
DUP2_RET i_dup2 DUP2_P(old, new);
TRUNCATE_RET i_truncate TRUNCATE_P(path, len);
FTRUNCATE_RET i_ftruncate FTRUNCATE_P(fd, len);
SCANDIR_RET i_scandir SCANDIR_P(dir, namelist, select, compar);
OPENDIR_RET i_opendir OPENDIR_P(name);
READDIR_RET i_readdir READDIR_P(dir);
CLOSEDIR_RET i_closedir CLOSEDIR_P(dir);
SEEKDIR_RET i_seekdir SEEKDIR_P(dir, offset);
REWINDDIR_RET i_rewinddir REWINDDIR_P(dir);
TELLDIR_RET i_telldir TELLDIR_P(dir);

EXECVE_RET i_execve EXECVE_P(file, argv, envp);
EXECVP_RET i_execvp EXECVP_P(path, argv);
EXECV_RET  i_execv  EXECV_P(path, argv);
FORK_RET  i_fork FORK_P();
VFORK_RET i_vfork VFORK_P();

UTIME_RET i_utime UTIME_P(path, buf);
ACCESS_RET i_access ACCESS_P(path, mode);

MMAP_RET i_mmap MMAP_P(addr, len, prot, flags, fd, offset);

READV_RET i_readv READV_P(fd, vec, cnt);
WRITEV_RET i_writev WRITEV_P(fd, vec, cnt);

FSYNC_RET i_fsync FSYNC_P(fd);

#endif


