#include "runix.h"
#include "net/net.h"

int getport(ulg host, ush *port)
{
  int s, n;
  struct sockaddr_in me = {AF_INET, *port};

  if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    return -1;

  me.sin_addr.s_addr = host;

  if(bind(s, &me, sizeof(me)) < 0)
    return -1;

  if(listen(s, 5) < 0)
    return -1;

  if(port == IPPORT_ANY) {
    n = sizeof(me);
    if(getsockname(s, &me, &n) < 0)
      return -1;
    *port = me.sin_port;
  }
  return s;
}
