#include "runix.h"
#include "net/net.h"

static int giveup = 0;

int aconnport(ulg host, ush port)
{
  int s;
  struct sockaddr_in she = {AF_INET, port};

  if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    giveup=1;
    return -1;
  }

  she.sin_addr.s_addr = host;

  if(connect(s, &she, sizeof(she)) < 0)
    return -1;

  return s;
}

int connport(char *name, ush port)
{
  int s;
  ulg host;
  struct hostent *he;
  int naddr, i, j;

  giveup = 0;
  
  if((host = inet_addr(name)) != -1)
    return aconnport(host, port);

  if(!(he = gethostbyname(name))) {
    errno = ENOENT;
    return -1;
  }

  for(naddr = 0; he -> h_addr_list[naddr]; naddr++);
  
  /*
   * The following is to optimize access to multi-homed hosts. Most useful
   * for several machines sharing the same name (like ds?.internic.net). For
   * others, router should return ONLY the best interface for outside world??
   * (anyway, one can always give explicit IP address).
   */

  for(i = 0; i < naddr; i++) {
    char *k = he -> h_addr_list[i];
    j = random() % naddr;
    he -> h_addr_list[i] = he -> h_addr_list[j];
    he -> h_addr_list[j] = k;
  }

  for(i = 0; !giveup && i < naddr; i++)
    if((s = aconnport(*(ulg *)(he -> h_addr_list[i]), port)) != -1)
      return s;

  return -1;
}
