#ifndef _RUNIX_H
#define _RUNIX_H

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <sys/uio.h>
#include <sys/resource.h>
#include <sys/mman.h>
#include <dirent.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <alloca.h>
#include <stdarg.h>
#include <utime.h>
#include <pwd.h>
#include <stdarg.h>
#include <limits.h>

#include <rpc/rpc.h>

/* 
 * For broken "MT-SAFE" libraries.
 */
#ifndef errno
extern int errno, sys_nerr;
extern char *sys_errlist[];
#endif

#ifdef MAIN
#	define IS(x) = (x)
#	define GLOBAL
#else
#	define IS(x)
#	define GLOBAL extern
#endif

typedef unsigned char uch;
typedef unsigned short ush;
typedef unsigned long ulg;

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif

/*
 * An attempt to reduce namespace polution.
 */

#ifndef DEBUG
#define debug    	_runix_debug
#define Basename 	_runix_Basename
#define eprintf  	_runix_eprintf
#define Malloc   	_runix_Malloc
#define Calloc	 	_runix_Calloc
#define Realloc  	_runix_Realloc
#define Strdup   	_runix_Strdup
#define randomize       _runix_randomize
#define enc_mode	_runix_enc_mode
#define dec_mode	_runix_dec_mode
#endif 

int debug;
char *Basename;

void eprintf(const char *format, ...);
void *Malloc(size_t size);
void *Calloc(size_t nmemb, size_t size);
#define Free free
void *Realloc(void *ptr, size_t size);
char *Strdup(const char *s);

/*
 * Those two functions are here until they can find a better residence.
 */

u_long enc_mode(mode_t mode);
mode_t dec_mode(u_long rmode);

#define LOGNAMESIZE  32
#define COOKIESIZE   32
#define VERSIONSIZE  32

#define VERSIONPRFX 	"RUnix V"
#define VERSION 	1

#define AUTHERR_NET	 1
#define AUTHERR_BADPASS  2
#define AUTHERR_BADREQ   3
#define AUTHERR_BADVERS  4
#define AUTHERR_DONTASK  5

#define PROC_INIT	0
#define PROC_FORK	1

#define FD_SHIFT (1<<20)
#define DEV_SHIFT 8349

/*
 * If it's not there, it must be default?
 */

#ifndef SA_RESTART
#define SA_RESTART 0
#endif

#if defined(sun) && !defined(__svr4__)
#	define memmove(d, s, i) bcopy((s),(d),(i))
#	define sunos4
#endif

#if defined(__linux__) && !defined(linux)
#	define linux __linux__
#endif

#if defined(MAP_ANONYMOUS) && !defined(MAP_ANON)
#	define MAP_ANON MAP_ANONYMOUS
#endif

#ifndef NAME_MAX
#	define NAME_MAX MAXNAMLEN
#endif

#ifdef __svr4__
#	define d_fileno d_ino
#endif

#endif
