#include "runix.h"
#include <syslog.h>

#define MAX_ERRLEN 1024

void eprintf(const char *p, ...)
{
  va_list l;
  char *error;
  char *t;
  char buf[MAX_ERRLEN];
  char ebuf[32];
  int percent, c, len;

  if(errno <= 0 || errno > sys_nerr) {
    error = ebuf;
    sprintf(error, "Error %u", errno);
  } else
    error = sys_errlist[errno];
  len = strlen(error);

  va_start(l, p);

  for(t = buf, percent = 0; c = *p; p++)
    if(!percent)
      if(c == '%')
	percent++;
      else
	*(t++) = c;
    else {
      if(c == 'm') {
	memcpy(t, error, len);
	t += len;
      } else {
	*(t++) = '%';
	*(t++) = c;
      }
      percent = 0;
    }

  if(percent)
    *(t++) = '%';
  if(t == buf || t[-1] != '\n')
    *(t++) = '\n';
  *t = '\0';

  if(debug) {
    fprintf(stderr, "%s: ", Basename);
    vfprintf(stderr, buf, l);
  } else {
    char buf2[MAX_ERRLEN];
    vsprintf(buf2, buf, l);
    syslog(LOG_ERR, buf2);
  }
}
  
  
