#ifndef _ANSIPROT_H
#define _ANSIPROT_H

/*
 * ANSI prototypes for redirected functions. You may need to edit
 * them to match your system. Also if your system doesn't have
 * smth_t  (like mode_t), this is a good place to define it.
 *
 * This is very messy. There needs to be a compiler option to relax
 * type checking for programs like this one.
 */

#define READ_P(fd, buf, count) (int fd, void *buf, size_t count)
#define READ_RET int

#define WRITE_P(fd, buf, count) (int fd, const void *buf, size_t count)
#define WRITE_RET int

#define UMASK_P(mask) (mode_t mask)
#define UMASK_RET mode_t

#define OPEN_P(file, flags) (const char *file, int flags, ...)
#define OPEN_RET int

#define CREAT_P(file, mode) (const char *file, mode_t mode)
#define CREAT_RET int

#define CLOSE_P(fd) (int fd)
#define CLOSE_RET int

#define LSEEK_P(fd,offset,whence) (int fd, off_t offset, int whence)
#define LSEEK_RET off_t

#ifdef linux
#define _XSTAT_P(ver, file, st) (int ver, const char *file, struct stat *st)
#define _XSTAT_RET int

#define _FXSTAT_P(ver, fd, st) (int ver, int fd, struct stat *st)
#define _FXSTAT_RET int

#define _LXSTAT_P(ver, file, st) (int ver, const char *file, struct stat *st)
#define _LXSTAT_RET int

#define _XMKNOD_P(ver, path, mode, dev) (int ver, const char *path, \
					 mode_t mode, dev_t *dev)
#define _XMKNOD_RET int

#endif

#define STAT_P(file,st) (const char *file, struct stat *st)
#define STAT_RET int

#define FSTAT_P(fd, st) (int fd, struct stat *st)
#define FSTAT_RET int

#define LSTAT_P(file, st) (const char *file, struct stat *st)
#define LSTAT_RET int

#define MKNOD_P(path, mode, dev) (const char *path, mode_t mode, dev_t dev)
#define MKNOD_RET int

#define CHMOD_P(path,mode) (const char *path, mode_t mode)
#define CHMOD_RET int

#define FCHMOD_P(fd, mode) (int fd, mode_t mode)
#define FCHMOD_RET int

#define CHOWN_P(path, uid, gid) (const char *path, uid_t uid, gid_t gid)
#define CHOWN_RET int

#define FCHOWN_P(fd, uid, gid) (int fd, uid_t uid, gid_t gid)
#define FCHOWN_RET int

#define MKDIR_P(path, mode) (const char *path, mode_t mode)
#define MKDIR_RET int

#define CHDIR_P(path) (const char *path)
#define CHDIR_RET int

#define RMDIR_P(path) (const char *path)
#define RMDIR_RET int

#define FCHDIR_P(fd) (int fd)
#define FCHDIR_RET int

#define LINK_P(old, new) (const char *old, const char *new)
#define LINK_RET int

#define UNLINK_P(path) (const char *path)
#define UNLINK_RET int

#define RENAME_P(old, new) (const char *old, const char *new)
#define RENAME_RET int

#define SYMLINK_P(old, new) (const char *old, const char *new)
#define SYMLINK_RET int

#ifdef __svr4__
#define READLINK_P(path, buf, bufsiz) (const char *path, void *buf, int bufsiz)
#else
#define READLINK_P(path, buf, bufsiz) (const char *path, char *buf, size_t bufsiz)
#endif
#define READLINK_RET int

#define GETCWD_P(buf, size) (char *buf, size_t size)
#define GETCWD_RET char *

#define GETWD_P(buf) (char *buf)
#define GETWD_RET char *

#define DUP_P(fd) (int fd)
#define DUP_RET int

#define DUP2_P(old,new) (int old, int new)
#define DUP2_RET int

#ifdef __svr4__
#define TRUNCATE_P(path,len) (const char *path, off_t len)
#else
#define TRUNCATE_P(path,len) (const char *path, size_t len)
#endif
#define TRUNCATE_RET int

#ifdef __svr4__
#define FTRUNCATE_P(fd,len) (int fd, off_t len)
#else
#define FTRUNCATE_P(fd,len) (int fd, size_t len)
#endif
#define FTRUNCATE_RET int

#define SCANDIR_P(dir, namelist, select, compar) \
	(const char *dir, struct dirent ***namelist, \
	      int (*select)(const struct dirent *), \
	      int (*compar)(const struct dirent * const *, \
			    const struct dirent * const *))
#define SCANDIR_RET int

#define OPENDIR_P(name) (const char *name)
#define OPENDIR_RET DIR *

#define CLOSEDIR_P(dir) (DIR *dir)
#define CLOSEDIR_RET int

#define READDIR_P(dir) (DIR *dir)
#define READDIR_RET struct dirent *

#define SEEKDIR_P(dir, offset) (DIR *dir, off_t offset)
#define SEEKDIR_RET void

#define REWINDDIR_P(dir) (DIR *dir)
#define REWINDDIR_RET void

#define TELLDIR_P(dir) (DIR *dir)
#define TELLDIR_RET off_t

#define EXECVE_P(filename, argv, envp) (const char *filename, \
		  char * const argv[], char * const envp[])
#define EXECVE_RET int

#define EXECL_P(path, arg) (const char *path, const char *arg, ...)
#define EXECL_RET int

#define EXECLE_P(path, arg) (const char *path, const char *arg, ...)
#define EXECLE_RET int

#define EXECLP_P(path, arg) (const char *path, const char *arg, ...)
#define EXECLP_RET int

#define EXECV_P(path, argv) (const char *path, char *const argv[])
#define EXECV_RET int

#define EXECVP_P(path, argv) (const char *path, char *const argv[])
#define EXECVP_RET int

#define FORK_P() (void)
#define FORK_RET pid_t

#define VFORK_P() (void)
#define VFORK_RET pid_t

#ifdef __svr4__
#define UTIME_P(path, buf) (const char *path, const struct utimbuf *buf)
#else
#define UTIME_P(path, buf) (const char *path, struct utimbuf *buf)
#endif
#define UTIME_RET int

#define UTIMES_P(file, tvp) (char *file, struct timeval *tvp)
#define UTIMES_RET int

#define EXIT_P(ret) (int ret)
#define EXIT_RET void

#define ACCESS_P(path, mode) (const char *path, int mode)
#define ACCESS_RET int

#define MMAP_P(addr, len, prot, flags, fd, offset) \
	(caddr_t addr, size_t len, int prot, int flags, int fd, off_t offset)
#define MMAP_RET caddr_t

#ifdef __svr4__

#define READV_P(fd, vec, cnt) (int fd, struct iovec *vec, int cnt)
#define READV_RET ssize_t

#define WRITEV_P(fd, vec, cnt) (int fd, const struct iovec *vec, int cnt)
#define WRITEV_RET ssize_t

#else

#define READV_P(fd, vec, cnt) (int fd, const struct iovec *vec, size_t cnt)
#define READV_RET int

#define WRITEV_P(fd, vec, cnt) (int fd, const struct iovec *vec, size_t cnt)
#define WRITEV_RET int

#endif

#define FSYNC_P(fd) (int fd)
#define FSYNC_RET int

#endif
