#include "runix.h"

void *Malloc(size_t size)
{
  void *r;

  if(r = malloc(size))
    return r;
  eprintf("malloc(%u): %m", size);
  exit(-1);
}

void *Calloc(size_t nmemb, size_t size)
{
  void *r;

  if(r = calloc(nmemb, size))
    return r;

  eprintf("calloc(%u, %u): %m", nmemb, size);
  exit(-1);
}

void *Realloc(void *ptr, size_t size)
{
  void *r;
  
  if(r = realloc(ptr, size))
    return r;

  free(ptr);
  eprintf("realloc(%u): %m", size);
  exit(-1);
}

char *Strdup(const char *s)
{
  return s ? strcpy(Malloc(strlen(s)), s) : NULL; 
}

