#ifndef _RUNIXLIB_H
#define _RUNIXLIB_H

#include "ansiprot.h"

#ifndef DEBUG
#define cookie_name _runix_cookie_name
#define rpc_fd      _runix_rpc_fd
#define clnt	    _runix_clnt
#define dec_errno   _runix_dec_errno
#define enc_open    _runix_enc_open
#define enc_lseek   _runix_enc_lseek
#define dec_stat    _runix_dec_stat
#define enc_access  _runix_enc_access

#define r_runixinit _runix_r_runixinit
#define r_runixcmd  _runix_r_runixcmd

#define r_open _runix_r_open
#define r_creat _runix_r_creat
#define r_read _runix_r_read
#define r_write _runix_r_write
#define r_close _runix_r_close
#define r_lseek _runix_r_lseek
#define r_stat _runix_r_stat
#define r_fstat _runix_r_fstat
#define r_lstat _runix_r_lstat
#define r_chmod _runix_r_chmod
#define r_fchmod _runix_r_fchmod
#define r_chown _runix_r_chown
#define r_fchown _runix_r_fchown
#define r_umask _runix_r_umask
#define r_mkdir _runix_r_mkdir
#define r_chdir _runix_r_chdir
#define r_rmdir _runix_r_rmdir
#define r_fchdir _runix_r_fchdir
#define r_link _runix_r_link
#define r_unlink _runix_r_unlink
#define r_rename _runix_r_rename
#define r_symlink _runix_r_symlink
#define r_readlink _runix_r_readlink
#define r_getcwd _runix_r_getcwd
#define r_getwd _runix_r_getwd
#define r_dup _runix_r_dup
#define r_dup2 _runix_r_dup2
#define r_truncate _runix_r_truncate
#define r_ftruncate _runix_r_ftruncate
#define r_scandir _runix_r_scandir
#define r_opendir _runix_r_opendir
#define r_readdir _runix_r_readdir
#define r_closedir _runix_r_closedir
#define r_seekdir _runix_r_seekdir
#define r_rewinddir _runix_r_rewinddir
#define r_telldir _runix_r_telldir
#define r_fork _runix_r_fork
#define r_utime _runix_r_utime
#define r_mknod _runix_r_mknod
#define r_access _runix_r_access
#define r_mmap _runix_r_mmap
#define r_readv _runix_r_readv
#define r_writev _runix_r_writev
#define r_fsync _runix_r_fsync

#endif

#ifndef _STEALTH_RUNIX_H
int rpc_fd;
CLIENT *clnt;
GLOBAL const char cookie_name[] IS(".runixkey_clnt");
#endif

int r_runixinit(char *server);
int r_runixcmd(char *server, uch cmd, ...);

#define EWHOKNOWS ENOTTY
#define EDEADRPC  ENETDOWN

OPEN_RET r_open OPEN_P(file, flags);
CREAT_RET r_creat CREAT_P(file, mode);
READ_RET r_read READ_P(fd, buf, count);
WRITE_RET r_write WRITE_P(fd, buf, count);
CLOSE_RET r_close CLOSE_P(fd);
LSEEK_RET r_lseek LSEEK_P(fd, offset, whence);
STAT_RET r_stat STAT_P(file, st);
FSTAT_RET r_fstat FSTAT_P(fd, st);
LSTAT_RET r_lstat LSTAT_P(file, st);
CHMOD_RET r_chmod CHMOD_P(path, mode);
FCHMOD_RET r_fchmod FCHMOD_P(fd, mode);
CHOWN_RET r_chown CHOWN_P(path, uid, gid);
FCHOWN_RET r_fchown FCHOWN_P(fd, uid, gid);
UMASK_RET r_umask UMASK_P(mask);
MKDIR_RET r_mkdir MKDIR_P(path, mode);
CHDIR_RET r_chdir CHDIR_P(path);
RMDIR_RET r_rmdir RMDIR_P(path);
FCHDIR_RET r_fchdir FCHDIR_P(fd);
LINK_RET r_link LINK_P(old, new);
UNLINK_RET r_unlink UNLINK_P(path);
RENAME_RET r_rename RENAME_P(old, new);
SYMLINK_RET r_symlink SYMLINK_P(old, new);
READLINK_RET r_readlink READLINK_P(path, buf, bufsiz);
GETCWD_RET r_getcwd GETCWD_P(buf, size);
GETWD_RET r_getwd GETWD_P(buf);
DUP_RET r_dup DUP_P(fd);
DUP2_RET r_dup2 DUP2_P(old, new);
TRUNCATE_RET r_truncate TRUNCATE_P(path, len);
FTRUNCATE_RET r_ftruncate FTRUNCATE_P(fd, len);
SCANDIR_RET r_scandir SCANDIR_P(dir, namelist, select, compar);
OPENDIR_RET r_opendir OPENDIR_P(name);
READDIR_RET r_readdir READDIR_P(dir);
CLOSEDIR_RET r_closedir CLOSEDIR_P(dir);
SEEKDIR_RET r_seekdir SEEKDIR_P(dir, offset);
REWINDDIR_RET r_rewinddir REWINDDIR_P(dir);
TELLDIR_RET r_telldir TELLDIR_P(dir);
int r_fork(u_long handle);
UTIME_RET r_utime UTIME_P(path, buf);
MKNOD_RET r_mknod MKNOD_P(path, mode, dev);
ACCESS_RET r_access ACCESS_P(path, mode);
MMAP_RET r_mmap MMAP_P(addr, len, prot, flags, fd, offset);
READV_RET r_readv READV_P(fd, vec, cnt);
WRITEV_RET r_writev WRITEV_P(fd, vec, cnt);


#ifndef _STEALTH_RUNIX_H
int dec_errno(unixerr code);
int enc_open(int flags);
rseek_method enc_lseek(int r);
struct stat dec_stat(rstat st);
u_short enc_access(int mode);
#endif

#define RUNIX_BLKSIZE 8192



#endif
