#define MAIN

#include "runix.h"
#include "net/net.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"

/*
 * This one goes wrong in SunOS 4.x library.
 */

_rpc_dtablesize()
{
  return FD_SETSIZE;
}

int r_runixcmd(char *server, uch cmd, ...)
{
  struct passwd *pw;

  static char *host, *cookie_file;
  char c, *p, *t;
  static char user[LOGNAMESIZE], version[VERSIONSIZE], cookie[COOKIESIZE];
  struct iovec io[] = {{&cmd, sizeof(cmd)},
			 {user, LOGNAMESIZE}, 
			 {cookie, COOKIESIZE}};
  int port = 0, fd;
  ulg vers, *handle;

  if(host) { free(host); host = NULL; }
  if(cookie_file) { free(cookie_file); cookie_file = NULL; }

  if(cmd == PROC_FORK) {
    va_list va;
    va_start(va, cmd);
    handle = va_arg(va, ulg *);
    va_end(va);
  }

  if(!server)
    server = getenv("RUNIXSVC");
  
  if(!server)
    server = "localhost";

  host = Strdup(server);
  if(p = strchr(host, ':')) {
    if(t = strchr(p+1, ':')) {
      if(sscanf(t+1, "%u", &port) != 1 || !port) {
	eprintf("Invalid RUNIXSVC port number '%s'", t+1);
	return -1;
      }
      *t = '\0';
    }
    strncpy(user, p+1, LOGNAMESIZE);
    user[LOGNAMESIZE-1] = '\0';
    *p = '\0';
  }
  
  if(!(pw = getpwuid(getuid()))) {
    eprintf("Unable to find username for uid %u", getuid());
    return -1;
  }
  endpwent();

  if(!*user) {
    strncpy(user, pw -> pw_name, LOGNAMESIZE);
    user[LOGNAMESIZE-1] = '\0';
  }

  if(!port) {
    struct servent *se;
    if(!(se = getservbyname("runix", "tcp"))) {
      eprintf("runix: unknown service");
      return -1;
    }
    port = se -> s_port;
  } else
    port = htons(port);

  if(!(p = getenv("HOME")))
     p = pw -> pw_dir;
    
  cookie_file = malloc(strlen(p)+sizeof(cookie_name)+1);
  sprintf(cookie_file, "%s/%s", p, cookie_name);

  if((fd = open(cookie_file, O_RDONLY)) < 0 ||
     read(fd, cookie, COOKIESIZE) != COOKIESIZE) {
    eprintf("%s: %m", cookie_file);
    return -1;
  }
  close(fd);
  
  if((fd = connport(*host ? host : "localhost", port)) == -1) {
    eprintf("connport: %m");
    return -1;
  }

  /*
   * Don't try to understand server version for now.
   * Backward-compatible clients may want to fall back to older protocol.
   */

  if(read(fd, version, VERSIONSIZE) != VERSIONSIZE) {
  exx:;
    eprintf("%s: %m", host);
    close(fd);
    return -1;
  }

  vers = htonl(VERSION);
  if(write(fd, &vers, sizeof(vers)) != sizeof(vers))
    goto exx;

  if(read(fd, &c, 1) != 1)
    goto exx;

  if(c)
    goto esvr;

  if(writev(fd, io, sizeof(io)/sizeof(struct iovec)) != 
	    LOGNAMESIZE + COOKIESIZE + sizeof(cmd)) {
    goto exx;
  }
  memset(cookie, 0, sizeof(cookie));
  
  if(read(fd, &c, 1) != 1)
    goto exx;

  if(c) {
  esvr:;
    close(fd);
    eprintf("%s: %s", host,
	    (c == AUTHERR_NET) ? "Network error" :
	    (c == AUTHERR_BADPASS) ? "Bad cookie" : 
	    (c == AUTHERR_BADREQ) ? "Unknown procedure" :
	    (c == AUTHERR_BADVERS) ? "Unsupported client version" :
	    (c == AUTHERR_DONTASK) ? "Error on server system" :
	    "Unknown server error");
    return -1;
  }

  if(cmd == PROC_FORK) {
    if(read(fd, handle, sizeof(ulg)) != sizeof(ulg))
      goto exx;
    *handle = ntohl(*handle);
  }

  free(host); free(cookie_file); host = cookie_file = NULL;

  return fd;
}

int r_runixinit(char *server)
{
  static int initdone;
  int fd;

  if(initdone) return 0;

  Basename = "runixlib";
  debug = 1;
  randomize();

  if((fd = r_runixcmd(server, PROC_INIT)) == -1)
    return -1;

  {
    struct rlimit rl;
    int pcur;
    getrlimit(RLIMIT_NOFILE, &rl);
    pcur = rl.rlim_cur;
    rpc_fd = rl.rlim_cur = rl.rlim_max;
    setrlimit(RLIMIT_NOFILE, &rl);
    if(dup2(fd, --rpc_fd) == -1) {
      close(fd);
      eprintf("dup2: %m"); /* But why? */
      return -1;
    }
    rl.rlim_cur = (pcur > rpc_fd) ? pcur - 1 : pcur;
    setrlimit(RLIMIT_NOFILE, &rl);
  }

  close(fd);

  {
    static struct sockaddr_in notme = { AF_INET };
    notme.sin_port = 1;
    notme.sin_addr.s_addr = INADDR_LOOPBACK;

    if(!(clnt = clnttcp_create(&notme, RUNIX_PROG, RUNIX_VERS, &rpc_fd,
                               0, 0))) {
      eprintf(clnt_spcreateerror("clnttcp_create"));
      close(rpc_fd);
      return -1;
    }
  }
  initdone++;
  return 0;
}

  
