#include "runix.h"
#include "rpc/runix_prot.h"

u_long enc_mode(mode_t mode)
{
  return  
    (u_long)(mode & 07777) | (
       S_ISREG(mode) ? RF_REG :
#ifdef S_ISBLK
       S_ISBLK(mode) ? RF_BLK :
#endif
#ifdef S_ISCHR
       S_ISCHR(mode) ? RF_CHR :
#endif
#ifdef S_ISSOCK
       S_ISSOCK(mode) ? RF_SOC :
#endif
#ifdef S_ISFIFO				      
       S_ISFIFO(mode) ? RF_PIP :
#endif
#ifdef S_ISLNK
       S_ISLNK(mode) ? RF_SYM :
#endif
    RF_DIR);
}

mode_t dec_mode(u_long rmode)
{
  mode_t r;

  switch(rmode & 0xFFFF0000) {
  case RF_REG:
    r = S_IFREG;
    break;
#ifdef S_ISBLK
  case RF_BLK:
    r = S_IFBLK;
    break;
#endif
#ifdef S_ISCHR
  case RF_CHR:
    r = S_IFCHR;
    break;
#endif
#ifdef S_ISSOCK
  case RF_SOC:
    r = S_IFSOCK;
    break;
#endif
#ifdef S_ISFIFO
  case RF_PIP:
    r = S_IFIFO;
    break;
#endif
#ifdef S_ISLNK
  case RF_SYM:
    r = S_IFLNK;
    break;
#endif
  default:
    r = S_IFDIR;
  }

  r |= (rmode & 07777);
  return r;
}
