#include "runix.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"

int dec_errno(unixerr code)
{
  switch (code) {
  case 0:
    return 0;
#ifdef EPERM
  case R_EPERM:
    return EPERM;
#endif
#ifdef ENOENT
  case R_ENOENT:
    return ENOENT;
#endif
#ifdef ENOEXEC
  case R_ENOEXEC:
    return ENOEXEC;
#endif
#ifdef EBADF
  case R_EBADF:
    return EBADF;
#endif
#ifdef EACCES
  case R_EACCES:
    return EACCES;
#endif
#ifdef EEXIST
  case R_EEXIST:
    return EEXIST;
#endif
#ifdef ENOTDIR
  case R_ENOTDIR:
    return ENOTDIR;
#endif
#ifdef EISDIR
  case R_EISDIR:
    return EISDIR;
#endif
#ifdef ENOSPC
  case R_ENOSPC:
    return ENOSPC;
#endif
#ifdef EROFS
  case R_EROFS:
    return EROFS;
#endif
#ifdef ENOTEMPTY
  case R_ENOTEMPTY:
    return ENOTEMPTY;
#endif
#ifdef ELOOP
  case R_ELOOP:
    return ELOOP;
#endif
#ifdef EDQUOT
  case R_EDQUOT:
    return EDQUOT;
#endif
  default:
    return EWHOKNOWS;
  }
}

int enc_open(int flags)
{
  int result;

  switch(flags & (O_RDONLY|O_RDWR|O_WRONLY)) {
  case O_RDONLY:
    result = RO_RDONLY;
    break;
  case O_WRONLY:
    result = RO_WRONLY;
    break;
  default:
    result = RO_RDWR;
  }

  return result | (flags & O_EXCL ? RO_EXCL : 0) |
    (flags & O_CREAT ? RO_CREAT : 0) |
    (flags & O_TRUNC ? RO_TRUNC : 0) |
    (flags & O_APPEND ? RO_APPEND : 0);
}

rseek_method enc_lseek(int r)
{
  return (r == SEEK_SET) ? RSEEK_SET :
         (r == SEEK_CUR) ? RSEEK_CUR : RSEEK_END;
}

struct stat dec_stat(rstat st)
{
  struct stat r;
  memset(&r, 0, sizeof(r));
  r.st_dev    = st.xst_dev;
  r.st_ino    = st.xst_ino;
  r.st_nlink  = st.xst_nlink;
  r.st_uid    = st.xst_uid;
  r.st_gid    = st.xst_gid;
  r.st_size   = st.xst_size;
  r.st_blocks = st.xst_blocks;
  r.st_atime  = st.xst_atime;
  r.st_mtime  = st.xst_mtime;
  r.st_ctime  = st.xst_ctime;

  r.st_mode   = dec_mode(st.xst_mode);

  r.st_blksize = RUNIX_BLKSIZE;

  return r;
}

u_short enc_access(int mode)
{
  return ((mode & R_OK) ? RR_OK : 0) |
         ((mode & W_OK) ? RW_OK : 0) |
	 ((mode & X_OK) ? RX_OK : 0) |
	 ((mode & F_OK) ? RF_OK : 0);
}

