#include "runix.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"

#include "clnt/chk.h"

/*
 * This is BIGTIME cheating :)
 */

#ifndef MAP_HASSEMAPHORE
#	define MAP_HASSEMAPHORE 0
#endif

#ifndef MAP_INHERIT
#	define MAP_INHERIT 0
#endif


MMAP_RET r_mmap MMAP_P(addr, len, prot, flags, fd, offset)
{
  int f;
  caddr_t r;
  LSEEK_RET pos, cnt;
  int xerrno;

  if((prot & PROT_WRITE) && (flags & MAP_SHARED)) {
    errno = ENOSYS;
    return (MMAP_RET)-1;
  }

  chk_fd(fd);

#ifdef MAP_ANON
  r = mmap(addr, len, PROT_READ|PROT_WRITE|PROT_EXEC, MAP_PRIVATE | MAP_ANON |
	   (flags & (MAP_INHERIT|MAP_HASSEMAPHORE)), -1, 0);
#else
  if((f = open("/dev/zero", O_RDWR))  == -1)
    return -1;
  r = mmap(addr, len, PROT_READ|PROT_WRITE|PROT_EXEC, MAP_PRIVATE |
	   (flags & (MAP_INHERIT|MAP_HASSEMAPHORE)), f, 0);
  close(f);
#endif

  if(r == (caddr_t)-1)
    return r;

  /*
   * If lseek fails still try to read from whatever is current offset
   */

  xerrno = errno;
  pos = r_lseek(fd, offset, SEEK_SET);
  errno = xerrno;

  cnt = r_read(fd, r, len);
  
  xerrno = errno;
  if(pos != -1) r_lseek(fd, pos, SEEK_SET);
  errno = xerrno;
    
  if(cnt == -1 || mprotect(r, len, prot) == -1) {
    munmap(r, len);
    return -1;
  }
  
  /*
   * mmap normally allows mapping to extend beyond the end of file.
   * So should we.
   */
  return r;
}
