#include "runix.h"
#include "rpc/runix_prot.h"
#include "clnt/runixlib.h"

#include "clnt/chk.h"

OPENDIR_RET r_opendir OPENDIR_P(name)
{
  dir_ret *r, *r2;
  int ret;
  
  if(!name) {
    errno = EFAULT;
    return NULL;
  }

  if(!*name) name = "";

  if(!(r = runix_readdir_1((char *)name, clnt))) {
    errno = EDEADRPC;
    return NULL;
  }

  if(r -> xerrno)
    errno = dec_errno(r -> xerrno);

  ret = r -> retcode;

  if(ret == -1) {
    XDR_FREE(xdr_dir_ret, r);
    return NULL;
  }

  r -> retcode = 0;

  if(!(r2 = malloc(sizeof(dir_ret)))) {
    XDR_FREE(xdr_dir_ret, r);
    return NULL;
  }

  memcpy(r2, r, sizeof(dir_ret));

  return (DIR *)r2;
}

READDIR_RET r_readdir READDIR_P(dir)
{
  dir_ret *r = (dir_ret *)dir;
  static struct dirent e;
  int len;

  if(!r) {
    errno = EFAULT;
    return NULL;
  }

  if(r -> retcode >= r -> dir.dir_len)
    return NULL;

  len = r -> dir.dir_val[r -> retcode].d_name.opq_len;

  e.d_fileno  = r -> dir.dir_val[r -> retcode].d_fileno;
  e.d_reclen = (sizeof(struct dirent) - NAME_MAX - 1 + len + 1 + 3) & ~3;
  memcpy(e.d_name, r -> dir.dir_val[r -> retcode].d_name.opq_val, len);
  e.d_name[len] = '\0';
  r -> retcode++;
  return &e;
}

CLOSEDIR_RET r_closedir CLOSEDIR_P(dir)
{
  chk_buf(dir);

  XDR_FREE(xdr_dir_ret, dir);
  free(dir);
  return 0;
}

SEEKDIR_RET r_seekdir SEEKDIR_P(dir, offset)
{
  if(!dir) {
    errno = EFAULT;
    return;
  }
  ((dir_ret *)dir) -> retcode = offset;
}

TELLDIR_RET r_telldir TELLDIR_P(dir)
{
  chk_buf(dir);
  return ((dir_ret *)dir) -> retcode;
}

REWINDDIR_RET r_rewinddir REWINDDIR_P(dir)
{
  r_seekdir(dir, 0);
}

/*
 * Taken from BSD 4.4Lite and slightly edited. May or may not be necessary
 * (the original tries to access a component of DIR *, which won't work).
 */


/*
 * The DIRSIZ macro is the minimum record length which will hold the directory
 * entry.  This requires the amount of space in struct dirent without the
 * d_name field, plus enough space for the name and a terminating nul byte
 * (dp->d_namlen + 1), rounded up to a 4 byte boundary.
 */
#undef DIRSIZ
/*
#define DIRSIZ(dp)                                                      \
        ((sizeof(struct dirent) - sizeof(dp)->d_name) +                 \
            (((dp)->d_namlen + 1 + 3) &~ 3))
*/
#define DIRSIZ(dp) (((dp)->d_reclen + 3) & ~3)

SCANDIR_RET r_scandir SCANDIR_P(dirname, namelist, select, dcomp)
{
        struct dirent *d, *p, **names;
        size_t nitems;
        long arraysz;
        DIR *dirp;

        if ((dirp = r_opendir(dirname)) == NULL)
                return(-1);

        arraysz = 64;
        names = (struct dirent **)malloc(arraysz * sizeof(struct dirent *));
        if (names == NULL)
                return(-1);

        nitems = 0;
        while ((d = r_readdir(dirp)) != NULL) {
                if (select != NULL && !(*select)(d))
                        continue;       /* just selected names */
                /*
                 * Make a minimum size copy of the data
                 */
                p = (struct dirent *)malloc(DIRSIZ(d));
                if (p == NULL)
                        return(-1);
                p->d_fileno = d->d_fileno;
                p->d_reclen = d->d_reclen;
                strcpy(p->d_name, d->d_name);
                /*
                 * Check to make sure the array has space left and
                 * realloc the maximum size.
                 */
                if (++nitems >= arraysz) {
                        arraysz += 64;
                        names = (struct dirent **)realloc((char *)names,
                                arraysz * sizeof(struct dirent *));
                        if (names == NULL)
                                return(-1);
                }
                names[nitems-1] = p;
        }
        r_closedir(dirp);
        if (nitems && dcomp != NULL)
                qsort(names, nitems, sizeof(struct dirent *), dcomp);
        *namelist = names;
        return(nitems);
}  
