#ifndef _CHK_H
#define _CHK_H

#define chk_fd(fd) do { \
   if((fd) < FD_SHIFT) { \
     errno = EBADF; \
     return -1; \
   } \
 } while(0)

#define chk_path(path) do { \
   if(!(path)) { \
     errno = EFAULT; \
     return -1; \
   } \
   if(!*(path)) (path) = "."; \
 } while(0)

#define chk_buf(buf) do { \
  if(!(buf)) { \
    errno = EFAULT; \
    return -1; \
  } \
 } while(0)

#define rpc_call(ret, r, f) do { \
  if(!((r) = (f))) { \
    errno = EDEADRPC; \
    return -1; \
  } \
  if((r) -> xerrno) \
    errno = dec_errno((r) -> xerrno); \
  (ret) = (r) -> retcode; \
 } while(0)

/*
 * Get rid of copious gcc warnings.
 */

#define XDR_FREE(a,b) xdr_free((xdrproc_t)(a), (char *)(b))

#endif
