/*
 * usleep.c - Provide the non-standard usleep() function where not
 * available.
 *
 * Author: Alex Plotnick
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 *
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * $Id: usleep.c,v 3.1 1998/06/29 00:25:51 adfh Exp $
 */

#include "qci_util_config.h"

#ifndef HAVE_USLEEP

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "qci_util.h"

/*
 * Emulate usleep() using select() on systems where it's not available.
 * (See `qci_util.h' for a description of why we're doing these silly things
 * with cpp.
 */
#if defined __linux__ || defined _OSF_SOURCE
void usleep(unsigned int usec)
#else
int usleep(usigned int usec)
#endif
{
    struct timeval tv;

    tv.tv_sec = usec / 1000000u;
    tv.tv_usec = usec % 1000000u;

    select(0, NULL, NULL, NULL, &tv);

#ifndef __linux__
    return 0;
#endif
}

#endif /* HAVE_USLEEP */
