/*
 * Basic Sanity Checks
 * Author: Eric Vought - QLUE Consulting, Inc.
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: basic.c,v 3.0 1998/05/21 17:14:02 adfh Exp $
 *
 * Perform (very) basic sanity checking- initialize, delete, set, get.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include <stdlib.h>
#include <tet_api.h>
#include <assert.h>
#include <hashtable.h>
#include <qstring.h>

void (*tet_startup)() = NULL;
void (*tet_cleanup)() = NULL;

void tp1();
void tp2();
void tp3();
void tp4();
void tp5();
void tp6();
void tp7();
void tp8();
void tp9();

struct tet_testlist tet_testlist[] = { 
    {tp1, 1},
    {tp2, 2},
    {tp3, 3},
    {tp4, 4},
    {tp5, 5},
    {tp6, 6},
    {tp7, 7},
    {tp8, 8},
    {tp9, 9},
    {NULL, 0}
};

/* Initialize and delete a hash. */
void tp1()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Initialize and delete a hash.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

    tet_result(TET_PASS);

} /* tp1 */

/* Call exists for non-existant key. */
void tp2()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Call exists for non-existant key.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */

    if (HASH_exists(hash, "foo"))
    {
	tet_result(TET_FAIL);
    } else {
	tet_result(TET_PASS);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp2 */


/* Set a value, using HASH_set. */
void tp3()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Set a value, using HASH_set.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_set(hash, "Foo", "Bar");
    if (HASH_exists(hash, "Foo"))
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp3 */

/* Set a value using HASH_add. */
void tp4()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Set a value, using HASH_add.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_add(hash, "Baz", "Bozo");

    if (HASH_exists(hash, "Baz"))
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp4 */

/* Set and retrieve a value using HASH_fetch. */
void tp5()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Set and retreive a value, using HASH_fetch.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_set(hash, "Baz", "Bozo");
 
    if (strcmp("Bozo", HASH_fetch(hash, "Baz")) == 0)
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp5 */

/* Add and retrieve a value using HASH_fetch. */
void tp6()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Add and retreive a value, using HASH_fetch.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_add(hash, "Baz", "Bozo");

    if (strcmp("Bozo", HASH_fetch(hash, "Baz")) == 0)
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp6 */

/* Add and remove a value using HASH_remove. */
void tp7()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Add and remove a value, using HASH_remove.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_set(hash, "Baz", "Bozo");

    HASH_remove(hash, "Baz");
    if (!HASH_exists(hash, "Baz"))
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp7 */

/* Add and remove a value using HASH_add/ HASH_remove. */
void tp8()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Add and remove a value, using HASH_remove.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_add(hash, "Baz", "Bozo");

    HASH_remove(hash, "Baz");
    if (!HASH_exists(hash, "Baz"))
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp8 */

/* Add and remove a value using HASH_clear. */
void tp9()
{
    Hash_Table hash;

    /* Initialize */
    tet_printf("basic:%d Add and remove a value, using HASH_clear.",
	       tet_thistest );

    hash = HASH_new(16);

    /* Test */
    HASH_add(hash, "Baz", "Bozo");

    HASH_clear(hash);
    if (!HASH_exists(hash, "Baz"))
    {
	tet_result(TET_PASS);
    } else {
	tet_result(TET_FAIL);
    }

    HASH_check_invariants(hash);

    /* Cleanup */
    HASH_delete(hash);

} /* tp9 */
