/*
 * strstr  (QCI)
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: strstr.c,v 3.1 1998/06/29 00:25:51 adfh Exp $
 *
 *  strstr - replacement function for systems missing the strstr call.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "qci_util_config.h"
#ifndef HAVE_STRSTR

#include <qstring.h>
#include "string.h"

/*
 * Somewhat crude, not-currently optimized implementation. Would like
 * to add some logic to reduce the number of unecessary comparisons and
 * function calls so that this can be efficient for long needles and
 * haystacks.
 */
char* strstr(const char *haystack, const char *needle)
{
    register int needle_length, i;
    register const char* index;

    assert(haystack != NULL);
    assert(needle != NULL);

    /* handle empty search strings properly ... */
    if (!(*needle)) return haystack;
    needle_length = strlen(needle);

    for(index = haystack;*index;index = strchr(index, *needle))
    {
	if (strncmp(index, needle, needle_length) == 0) return index;
    }
    return NULL;
} /* strstr */

#endif /* ndev HAVE_STRSTR */
