/*
 * strspn (QCI)
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: strspn.c,v 3.1 1998/06/29 00:25:50 adfh Exp $
 *
 * Replacement functions for systems without the strspn/strcspn functions.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "qci_util_config.h"

#ifndef HAVE_STRSPN

#include "qci_util.h"
#include <unistd.h>

size_t strspn(const char* s, const char* accept)
{
    register int i = 0;
    bool match = FALSE;
    int num_chars = 0;
    const char* t;

    assert(string != NULL);
    assert(accept != NULL);

    num_chars = strlen(accept);

    /* Find the first character not in accept */
    for(t = s; *t; t++)
    {
	match = FALSE;
	for(i = 0; i < num_chars; i++)
	{
	    if (accept[i] == *t)
	    {
		match = TRUE;
		break;
	    }
	}
	if (match == FALSE) break;
    }

    return (t - s);
} /* strspn */

size_t strcspn(const char* s, const char* reject)
{
    register size_t i = 0;
    bool match = FALSE;
    int num_chars = 0;
    const char* t;

    assert(s != NULL);
    assert(reject != NULL);

    num_chars = strlen(reject);

    /* Find the first character in reject */
    for(t = s; *t; t++)
    {
	match = FALSE;
	for(i = 0; i < num_chars; i++)
	{
	    if (reject[i] == *t)
		goto FOUND;
	}
    }

 FOUND:
    return t - s;
} /* strcspn */

#endif /* ndef HAVE_STRSPN */
