/*
 * strdup  (QCI)
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: strdup.c,v 3.1 1998/06/29 00:25:50 adfh Exp $
 *
 *  strdup - replacement function for systems missing the strdup call.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "qci_util_config.h"
#ifndef HAVE_STRDUP

#include <assert.h>
#include <stdlib.h>

char* strdup(const char* s)
{
    char* newstr = NULL;

    assert(s != NULL);
    newstr = malloc(strlen(s) + 1);
    if (!newstr) return NULL;

    strcpy(newstr, s);
    return newstr;
} /* strdup */

#endif /* ndef HAVE_STRDUP */
