/*
 * strcasecmp  (QCI)
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: strcasecmp.c,v 3.1 1998/06/29 00:25:50 adfh Exp $
 *
 *  strcasecmp - replacement function for systems missing the
 *     strcasecmp/strncasecmp  call.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */
#include "qci_util_config.h"

#ifndef HAVE_STRCASECMP

#include <ctype.h>
#include "qstring.h"

int strcasecmp (const char* s1, const char* s2)
{
    register const char *t1, *t2;
    char lc1, lc2;

    for (t1 = s1, t2 = s2; *t1 && *t2; t1++, t2++)
    {
	lc1 = toupper(*t1);
	lc2 = toupper(*t2);

	if (lc1 != lc2)
	    return (lc1 < lc2) ? -1 : 1;
    }
    if (*t1) return 1;       /* p was longer than q */
    if (*t2) return -1;      /* p was shorter than q */
    return 0;               /* Exact match */
} /* strcasecmp */

int strncasecmp (const char* s1, const char* s2, size_t n)
{
    register const char *t1, *t2;
    char lc1, lc2;
    int i = 0;

    for (t1 = s1, t2 = s2; *t1 && *t2; t1++, t2++)
    {
	if (i == n) goto RAN_OUT;
	i++;

	lc1 = toupper(*t1);
	lc2 = toupper(*t2);

	if (lc1 != lc2)
	    return (lc1 < lc2) ? -1 : 1;
    }
    if (*t1) return 1;       /* p was longer than q */
    if (*t2) return -1;      /* p was shorter than q */

 RAN_OUT:
    return 0;               /* Exact match */
} /* strncasecmp */

#endif /* HAVE_STRCASECMP */
