/*
 * Network Utilities (NUTIL)
 * Author: Eric Vought
 *	Copright (C) 1998 QLUE Consulting, Inc.
 * $Id: net_util.h,v 3.1 1998/08/22 18:26:16 adfh Exp $
 *
 * Network Communications Utlities package
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _NET_UTIL_H
#define _NET_UTIL_H

#include <qci_util_config.h>

#include <sys/types.h>
#include <sys/socket.h>
/* on AIX, socklen_t is defined in stdlib.h */
#include <stdlib.h>

/* Wraps the socket function- exits with an error if the socket cannot be
 * opened. */
int xsocket(int family, int type, int protocol);

void xbind(int fd, const struct sockaddr *addr, socklen_t addr_len);

void xlisten(int fd, int queue_length);

int xaccept(int fd, struct sockaddr *addr, socklen_t *addr_len);

#endif /* ndef _NET_UTIL_H */
