/*
 * Network Utilities (NUTIL)
 * Author: Eric Vought
 *	Copright (C) 1998 QLUE Consulting, Inc.
 * $Id: net_util.c,v 3.0 1998/05/21 17:13:48 adfh Exp $
 *
 * Network Communications Utlities package
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "qci_util_config.h"

#include "net_util.h"
#include "qci_util.h"
#include <errno.h>

/* for strerror */
#include <string.h>

/*
 * Wraps the socket function- exits with an error if the socket cannot be
 * opened.
 */
int xsocket(int family, int type, int protocol)
{
    int n;

    if ((n = socket(family, type, protocol)) < 0)
	QCI_fatal_error(strerror(errno));

    return n;
} /* xsocket */

void xbind(int fd, const struct sockaddr *addr, socklen_t addr_len)
{
    if (bind(fd, addr, addr_len) < 0)
	QCI_fatal_error(strerror(errno));
} /* xbind */

void xlisten(int fd, int queue_length)
{
    if (listen(fd, queue_length) < 0)
	QCI_fatal_error(strerror(errno));
} /* xlisten */

int xaccept(int fd, struct sockaddr *addr, socklen_t *addr_len)
{
    int n;

 again:
    if ((n = accept(fd, addr, addr_len)) < 0)
    {
#ifdef  EPROTO
	if (errno == EPROTO || errno == ECONNABORTED)
#else
	if (errno == ECONNABORTED)
#endif
	    goto again;
	else
	    QCI_fatal_error(strerror(errno));
    }
    return(n);
} /* xaccept */
