/*
 * memcmp  (QCI)
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 * $Id: memcmp.c,v 3.1 1998/06/29 00:25:50 adfh Exp $
 *
 *  memcmp - replacement function for systems missing the memcmp call.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "qci_util_config.h"
#ifndef HAVE_MEMCMP

#include "qci_util.h"
#include "unistd.h"

int memcmp(const void *s1, const void *s2, size_t n)
{
    const register unsigned char *c1, *c2;
    register int i;

    for(i = 0; i < count; i++, c1++, c2++)
    {
	if (*c1 != *c2)
	{
	    return (*c1 > *c2) ? 1 : -1;
	}
    }

    return 0;
} /* memcmp */

#endif HAVE_MEMCMP
