/*
 * HashTable (HASH)
 * Author: Alex Plotnick - QLUE Consulting, Inc.
 * $Id: hashtable.h,v 3.0 1998/05/21 17:13:47 adfh Exp $
 *
 * A hashtable module using char* for both keys and values.
 */

/*
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _HASH_H
#define _HASH_H

typedef struct _Hash_Node* Hash_Node;
typedef struct _Hash_Table* Hash_Table;

struct _Hash_Node
{
    char* key;
    char* value;
    Hash_Node next;
};

struct _Hash_Table
{
    int size;			/* Size of nodes[] */
    int count;			/* Number of elements */
    int resize_threshold;	/* If count >= resize_threshold, resize */
    Hash_Node* nodes;		/* Array of size `size' of nodes */

    Hash_Node node_cache;
    int hashval_cache;
};

const int HASH_DEFAULT_INITIAL_SIZE;


/* Function prototypes */

/* Allocate and return a new hashtable */
Hash_Table HASH_new(int size);

/* Deallocate all nodes in a hash and return to the empty state. */
void HASH_clear(Hash_Table ht);

/* Deallocate and invalidate a hashtable. */
void HASH_delete(Hash_Table ht);

/* Add a new node. Optimized for bulk inserts- does not cause resizes. */
void HASH_add(Hash_Table ht, const char* key, const char* value);

/* Associate a value with a key. */
void HASH_set(Hash_Table ht, const char* key, const char* value);

/* Remove a key. */
void HASH_remove(Hash_Table ht, const char* key);

/* Return true if a key appears in the table, false otherwise. */
int HASH_exists(Hash_Table ht, const char* key);

/* Retrieve the value associated with key, NULL if not set. */
const char* HASH_fetch(Hash_Table ht, const char* key);

/* Force the hashtable to resize itself to an optimal number of buckets. */
void HASH_resize(Hash_Table ht);

/* Return info on the distribution of nodes in the table. */
void HASH_info(Hash_Table ht);

/*
 * Perform internal integrity checking and abort with info if something is
 * wrong.
 */
void HASH_check_invariants(Hash_Table ht);


#endif /* _HASH_H */
