/*
 * allocating sprintf - Provide the non-standard asprintf() function
 * where not available.
 *
 * Author: Eric Vought
 *	Copyright (C) 1998 QLUE Consulting, Inc.
 *
 * See the file "LICENSE.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * $Id: asprintf.c,v 3.3 1998/06/29 00:25:49 adfh Exp $
 */
#include "qci_util_config.h"
#ifndef HAVE_ASPRINTF

#include <stdio.h>
#include <stdarg.h>
#include <qci_util.h>


/*
 * asprintf replacement using realloc and snprintf. Very efficient for
 * strings less than 64 characters long. Efficiency drops off with length.
 * Memory allocations are CHECKED and out of memory conditons will cause
 * a fatal error.
 */ 
int vasprintf(char** buffer, const char* format, va_list ap)
{
    int buf_size = 64;
    int real_size;
    *buffer = xmalloc(buf_size);

    while ((real_size = vsnprintf(*buffer, buf_size, format, ap)) == -1)
    {
	buf_size <<= 1;
	*buffer = realloc(*buffer, buf_size);
    }

    /* shrink buffer back down */
    *buffer = realloc(*buffer, real_size);

    return real_size;
} /* vasprintf */

int asprintf(char** buffer, const char* format, ...)
{
    va_list args;

    va_start(args, format);

    return vasprintf(buffer, format, args);
} /* asprintf */


#endif /* HAVE_ASPRINTF */
    

