dnl aclocal.m4 generated automatically by aclocal 1.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl Local macros

dnl Usage:
dnl AC_HEADER_FIND(header_file, search_path [, ACTION-IF-FOUND
dnl		   [, ACTION-IF-NOT-FOUND]]])
dnl where `header_file' is the header you are looking for, and `search_path'
dnl is a space-separated list of places to look for it.
dnl
AC_DEFUN(AC_HEADER_FIND,
[
AC_MSG_CHECKING([for $1])
ac_save_CPPFLAGS="$CPPFLAGS"

dnl Try default locations first
AC_TRY_CPP([#include <$1>], [found_header=yes], [found_header=no])

if test $found_header = no; then
    for path in $2; do
	CPPFLAGS="$ac_save_CPPFLAGS -I$path"
	AC_TRY_CPP([#include <$1>], [found_header=yes; break])
    done
fi

if test $found_header = yes; then
    AC_MSG_RESULT(yes)
    ifelse([$3], , :, [$3])
else
    AC_MSG_RESULT(no)
    CPPFLAGS="$ac_save_CPPFLAGS"
    ifelse([$4], , :, [$4])
fi
])

dnl Usage:
dnl AC_LIB_FIND(lib, search_path [, ACTION-IF-FOUND
dnl		[, ACTION-IF-NOT-FOUND]]])
dnl where `lib' is the library you are looking for, and `search_path'
dnl is a space-separated list of places to look for it.
dnl
AC_DEFUN(AC_LIB_FIND,
[
AC_MSG_CHECKING([for lib$1])
ac_save_LIBS="$LIBS"

dnl Try default paths first
LIBS="$LIBS -l$1"
AC_TRY_LINK( , [main()], [ac_found_lib=yes], [ac_found_lib=no])

if test $ac_found_lib = no && test -n "$2"; then
    for path in $2; do
	LIBS="$ac_save_LIBS -L$path -l$1"
	AC_TRY_LINK( , [main()], [ac_found_lib=yes; break])
    done
fi

if test $ac_found_lib = yes; then
    AC_MSG_RESULT(yes)
    ifelse([$3], , :, [$3])
else
    AC_MSG_RESULT(no)
    LIBS="$ac_save_LIBS"
    ifelse([$4], , :, [$4])
fi
])

dnl Usage: AC_LIB_SOCKET
dnl The following is stolen from the Tcl 8.0 `configure.in'...
dnl	Check for the existence of the -lsocket and -lnsl libraries.
dnl	The order here is important, so that they end up in the right
dnl	order in the command line generated by make.  Here are some
dnl	special considerations:
dnl	1. Use "connect" and "accept" to check for -lsocket, and
dnl	   "gethostbyname" to check for -lnsl.
dnl	2. Use each function name only once:  can't redo a check because
dnl	   autoconf caches the results of the last check and won't redo it.
dnl	3. Use -lnsl and -lsocket only if they supply procedures that
dnl	   aren't already present in the normal libraries.  This is because
dnl	   IRIX 5.2 has libraries, but they aren't needed and they're
dnl	   bogus:  they goof up name resolution if used.
dnl	4. On some SVR4 systems, can't use -lsocket without -lnsl too.
dnl	   To get around this problem, check for both libraries together
dnl	   if -lsocket doesn't work by itself.
dnl
AC_DEFUN(AC_LIB_SOCKET,
[
ac_checkBoth=0
AC_CHECK_FUNC(connect, ac_checkSocket=0, ac_checkSocket=1)
if test "$ac_checkSocket" = 1; then
    AC_CHECK_LIB(socket, main, LIBS="$LIBS -lsocket", ac_checkBoth=1)
fi
if test "$ac_checkBoth" = 1; then
    ac_oldLibs=$LIBS
    LIBS="$LIBS -lsocket -lnsl"
    AC_CHECK_FUNC(accept, ac_checkNsl=0, [LIBS=$ac_oldLibs])
fi
AC_CHECK_FUNC(gethostbyname, , AC_CHECK_LIB(nsl, main, [LIBS="$LIBS -lnsl"]))
])

dnl Usage: AC_C_SHLIB
dnl Attempts to figure out how to build shared libraries on the host-os, and
dnl sets the following variables (if successful):
dnl	SHLIB_CFLAGS	=> Flags to pass to the compiler when compiling
dnl			   the components of a shared lib.  Usually includes
dnl			   the flag to generate PIC.
dnl	SHLIB_LD	=> The command used to create a shared library.
dnl	SHLIB_SUFFIX	=> The suffix used for shared libraries.
dnl	BUILD_SHLIB	=> `yes' if we could figure out how to build a shared
dnl			   library on this system, and `no' otherwise.
dnl
dnl Some of the platform-specific options were taken from GNU Libtool.
dnl
dnl PLEASE NOTE: This is currently very limited, and should not be used
dnl as a general-purpose tool.  Use GNU Libtool if at all possible.
dnl
AC_DEFUN(AC_C_SHLIB,
[
SHLIB_CFLAGS=""
SHLIB_LD=""
SHLIB_SUFFIX=""
BUILD_SHLIB=""

if test -z "$host_os"; then
    AC_CANONICAL_HOST
fi

AC_MSG_CHECKING([how to build shared libraries])
case $host_os in
    linux*)
	SHLIB_CFLAGS="-fPIC"
	SHLIB_LD="$CC -shared"
	SHLIB_SUFFIX=".so"
	;;

    solaris2*)
	SHLIB_CFLAGS="-KPIC"
	SHLIB_LD="/usr/ccs/bin/ld -G"
	SHLIB_SUFFIX=".so"
	;;

    osf3* | osf4*)
	# All OSF/1 code is PIC
	SHLIB_LD="ld -shared"
	SHLIB_SUFFIX=".so"
	;;

    hpux9* | hpux10* | hpux11*)
	SHLIB_CFLAGS="+Z"
	SHLIB_LD="ld -b"
	SHLIB_SUFFIX=".sl"
	;;

    irix5* | irix6*)
	# PIC (with -KPIC) is the default
	SHLIB_LD="ld -shared"
	SHLIB_SUFFIX=".so"
esac

# If we're using gcc, SHLIB_CFLAGS should always be `-fPIC', and not whatever
# platform-specific flags were determined above.
if test "$GCC" = "yes" -a -n "$SHLIB_SUFFIX"; then
    SHLIB_CFLAGS="-fPIC"
fi

if test -n "$SHLIB_SUFFIX"; then
    AC_MSG_RESULT(ok)
    BUILD_SHLIB="yes"
else
    AC_MSG_RESULT(unknown)
    BUILD_SHLIB="no"
fi

AC_SUBST(BUILD_SHLIB)
AC_SUBST(SHLIB_CFLAGS)
AC_SUBST(SHLIB_LD)
AC_SUBST(SHLIB_SUFFIX)
])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AM_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE")
AC_DEFINE_UNQUOTED(VERSION, "$VERSION"))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])


# serial 1

AC_DEFUN(AM_PROG_INSTALL,
[AC_REQUIRE([AC_PROG_INSTALL])
test -z "$INSTALL_SCRIPT" && INSTALL_SCRIPT='${INSTALL_PROGRAM}'
AC_SUBST(INSTALL_SCRIPT)dnl
])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

