dnl Local macros

dnl Usage:
dnl AC_HEADER_FIND(header_file, search_path [, ACTION-IF-FOUND
dnl		   [, ACTION-IF-NOT-FOUND]]])
dnl where `header_file' is the header you are looking for, and `search_path'
dnl is a space-separated list of places to look for it.
dnl
AC_DEFUN(AC_HEADER_FIND,
[
AC_MSG_CHECKING([for $1])
ac_save_CPPFLAGS="$CPPFLAGS"

dnl Try default locations first
AC_TRY_CPP([#include <$1>], [found_header=yes], [found_header=no])

if test $found_header = no; then
    for path in $2; do
	CPPFLAGS="$ac_save_CPPFLAGS -I$path"
	AC_TRY_CPP([#include <$1>], [found_header=yes; break])
    done
fi

if test $found_header = yes; then
    AC_MSG_RESULT(yes)
    ifelse([$3], , :, [$3])
else
    AC_MSG_RESULT(no)
    CPPFLAGS="$ac_save_CPPFLAGS"
    ifelse([$4], , :, [$4])
fi
])

dnl Usage:
dnl AC_LIB_FIND(lib, search_path [, ACTION-IF-FOUND
dnl		[, ACTION-IF-NOT-FOUND]]])
dnl where `lib' is the library you are looking for, and `search_path'
dnl is a space-separated list of places to look for it.
dnl
AC_DEFUN(AC_LIB_FIND,
[
AC_MSG_CHECKING([for lib$1])
ac_save_LIBS="$LIBS"

dnl Try default paths first
LIBS="$LIBS -l$1"
AC_TRY_LINK( , [main()], [ac_found_lib=yes], [ac_found_lib=no])

if test $ac_found_lib = no && test -n "$2"; then
    for path in $2; do
	LIBS="$ac_save_LIBS -L$path -l$1"
	AC_TRY_LINK( , [main()], [ac_found_lib=yes; break])
    done
fi

if test $ac_found_lib = yes; then
    AC_MSG_RESULT(yes)
    ifelse([$3], , :, [$3])
else
    AC_MSG_RESULT(no)
    LIBS="$ac_save_LIBS"
    ifelse([$4], , :, [$4])
fi
])

dnl Usage: AC_LIB_SOCKET
dnl The following is stolen from the Tcl 8.0 `configure.in'...
dnl	Check for the existence of the -lsocket and -lnsl libraries.
dnl	The order here is important, so that they end up in the right
dnl	order in the command line generated by make.  Here are some
dnl	special considerations:
dnl	1. Use "connect" and "accept" to check for -lsocket, and
dnl	   "gethostbyname" to check for -lnsl.
dnl	2. Use each function name only once:  can't redo a check because
dnl	   autoconf caches the results of the last check and won't redo it.
dnl	3. Use -lnsl and -lsocket only if they supply procedures that
dnl	   aren't already present in the normal libraries.  This is because
dnl	   IRIX 5.2 has libraries, but they aren't needed and they're
dnl	   bogus:  they goof up name resolution if used.
dnl	4. On some SVR4 systems, can't use -lsocket without -lnsl too.
dnl	   To get around this problem, check for both libraries together
dnl	   if -lsocket doesn't work by itself.
dnl
AC_DEFUN(AC_LIB_SOCKET,
[
ac_checkBoth=0
AC_CHECK_FUNC(connect, ac_checkSocket=0, ac_checkSocket=1)
if test "$ac_checkSocket" = 1; then
    AC_CHECK_LIB(socket, main, LIBS="$LIBS -lsocket", ac_checkBoth=1)
fi
if test "$ac_checkBoth" = 1; then
    ac_oldLibs=$LIBS
    LIBS="$LIBS -lsocket -lnsl"
    AC_CHECK_FUNC(accept, ac_checkNsl=0, [LIBS=$ac_oldLibs])
fi
AC_CHECK_FUNC(gethostbyname, , AC_CHECK_LIB(nsl, main, [LIBS="$LIBS -lnsl"]))
])

dnl Usage: AC_C_SHLIB
dnl Attempts to figure out how to build shared libraries on the host-os, and
dnl sets the following variables (if successful):
dnl	SHLIB_CFLAGS	=> Flags to pass to the compiler when compiling
dnl			   the components of a shared lib.  Usually includes
dnl			   the flag to generate PIC.
dnl	SHLIB_LD	=> The command used to create a shared library.
dnl	SHLIB_SUFFIX	=> The suffix used for shared libraries.
dnl	BUILD_SHLIB	=> `yes' if we could figure out how to build a shared
dnl			   library on this system, and `no' otherwise.
dnl
dnl Some of the platform-specific options were taken from GNU Libtool.
dnl
dnl PLEASE NOTE: This is currently very limited, and should not be used
dnl as a general-purpose tool.  Use GNU Libtool if at all possible.
dnl
AC_DEFUN(AC_C_SHLIB,
[
SHLIB_CFLAGS=""
SHLIB_LD=""
SHLIB_SUFFIX=""
BUILD_SHLIB=""

if test -z "$host_os"; then
    AC_CANONICAL_HOST
fi

AC_MSG_CHECKING([how to build shared libraries])
case $host_os in
    linux*)
	SHLIB_CFLAGS="-fPIC"
	SHLIB_LD="$CC -shared"
	SHLIB_SUFFIX=".so"
	;;

    solaris2*)
	SHLIB_CFLAGS="-KPIC"
	SHLIB_LD="/usr/ccs/bin/ld -G"
	SHLIB_SUFFIX=".so"
	;;

    osf3* | osf4*)
	# All OSF/1 code is PIC
	SHLIB_LD="ld -shared"
	SHLIB_SUFFIX=".so"
	;;

    hpux9* | hpux10* | hpux11*)
	SHLIB_CFLAGS="+Z"
	SHLIB_LD="ld -b"
	SHLIB_SUFFIX=".sl"
	;;

    irix5* | irix6*)
	# PIC (with -KPIC) is the default
	SHLIB_LD="ld -shared"
	SHLIB_SUFFIX=".so"
esac

# If we're using gcc, SHLIB_CFLAGS should always be `-fPIC', and not whatever
# platform-specific flags were determined above.
if test "$GCC" = "yes" -a -n "$SHLIB_SUFFIX"; then
    SHLIB_CFLAGS="-fPIC"
fi

if test -n "$SHLIB_SUFFIX"; then
    AC_MSG_RESULT(ok)
    BUILD_SHLIB="yes"
else
    AC_MSG_RESULT(unknown)
    BUILD_SHLIB="no"
fi

AC_SUBST(BUILD_SHLIB)
AC_SUBST(SHLIB_CFLAGS)
AC_SUBST(SHLIB_LD)
AC_SUBST(SHLIB_SUFFIX)
])
