/* Integer class implementation (non-inline functions).
   Copyright (C) 2001 Roberto Bagnara <bagnara@cs.unipr.it>

This file is part of the Parma Polyhedra Library (PPL).

The PPL is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

The PPL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

For the most up-to-date information see the Parma Polyhedra Library
site: http://www.cs.unipr.it/ppl/ . */

#include <config.h>

#include "Integer.defs.hh"

#include <iostream>
#include <string>

using std::istream;
using std::ostream;
using std::string;

namespace Parma_Polyhedra_Library {

istream&
operator >>(istream& s, Integer& x) {
  string buffer;
  s >> buffer;
  mpz_set_str(x.v, buffer.c_str(), 0);
  return s;
}

ostream&
operator <<(ostream& s, const Integer& x) {
  char* buffer = mpz_get_str(0, 0, x.v);
  s << buffer;
  free(buffer);
  return s;
}

// The state for random number generation.
Integer::RandomState Integer::random_state;

} // namespace Parma_Polyhedra_Library
