/*
 * linux.c -- lightweight process initialisation for linux
 * Copyright (C) 1992-3 Stephen Crane.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * author: Stephen Crane, (jsc@doc.ic.ac.uk), Department of Computing,
 * Imperial College of Science, Technology and Medicine, 180 Queen's
 * Gate, London SW7 2BZ, England.
 *
 * Modified to run on 386/486 machines running linux by:
 * Mark Little (M.C.Little@newcastle.ac.uk), Department of Computing
 * Science, The University, Newcastle upon Tyne, NE1 7RU, England.
 * 7/7/93
 */
#include <sys/param.h>

#include "lwp.h"

/*
 * initp -- initialise a new process's context.
 */
void initp (struct pcb *newp, void *sp)
{
	newp->context->__sp = sp;
	newp->context->__bp = sp;
	newp->context->__pc = (void *)wrapp;
}

/*
 * getdtablesize -- linux hasn't got this
 */
int getdtablesize (void)
{
	return (NOFILE);
}
