/*###########################################################################
type:             C++ file logmin.cc
function:         demo for logic minimizer
project:          diplom
programer    :    Mario Hahnemann 
organisation:     IA/Fak f. techn. & theoretische Informatik
                  Technische Universitaet Ilmenau
first alpha code: 22.03.1998
@UPDATE_1	: 10.02.1999
@UPDATE_2	: 03.06.1999
#############################################################################*/

#include "logic.h"
#include "time.h"
#include "unistd.h"
#include <sys/types.h>
#include <sys/wait.h>

int main(int argc, char *argv[])
   {   
   int argoff = 0;
   listptr liste = NIL;
   listptr secliste = NIL;
   listptr tablist = NIL;
   listptr help = NIL;
   clock_t time1, time2;
   time1 = clock();
   unsigned int itera, alg, errorg;
   errorg = 0;
   if (argc > 1)
      {
      /* helpscreen */
      if ((!strcmp(argv[1],"-h")) || (((argc < 5) || (argc > 6)) \
          && (strcmp(argv[1],"-v"))  ))
         {
         printf("\nsyntax [-h | -v | on-set-file [dc-set-file]");
         printf(" out-file proc primetab]\n\n");
         printf("  -h  this helpscreen\n");
         printf("  -v  version\n\n");
         printf("  proc = 0     : Espresso-Signature\n");
         printf("  proc = 1     : full Quine\n");
         printf("  proc > 1     : number of Quine iterations\n\n");
         printf("  primetab = 0 : primetab off\n");
         printf("  primetab > 0 : number of primetab iterations\n\n");
         printf("  primetab = a : autoiterate\n\n");
         }
      else if (!strcmp(argv[1],"-v"))
         {
         printf("logic-minimizer\n");
         printf("Mario Hahnemann\n");
         printf("TU-Ilmenau\n");
         printf("V 1.11 / 1999 \n");
         }
      else
         {
         /* test command line */
         if (argc == 5) argoff = 1;
         if (strcmp(argv[5 - argoff], "a")) 
            {
            itera = atoi(argv[5 - argoff]);
            } 
         else itera = 1;
         alg = atoi(argv[4 - argoff]);
         errorg = 0;
         /* start timer */
         time1 = clock();          
         liste = (L *) readlogic(argv[1]);
         if (liste == NIL) 
            {
            printf("error while loading %s !\n", argv[1]);
            if (fileerror == NOT_EXIST) printf("file not exist\n");
            else if (fileerror == EMPTY) printf("file is empty\n");
            else if (fileerror == BAD_FILE) printf("bad file format\n");
            errorg = 1;
            }
         if (argoff == 0) secliste = (L *) readlogic(argv[2]);
         if ((secliste == NIL) && (argoff == 0)) 
            {
            printf("error while loading %s !\n", argv[2]);
            if (fileerror == NOT_EXIST) 
               {
               printf("file not exist\n");
               errorg = 1;
               }
            if (fileerror == BAD_FILE) 
               {
               printf("bad file format\n");
               errorg = 1;
               }            
            }
         /* process Signature */   
         if ((alg == 0) && (errorg == 0))
            {
            /* concat lists */
            liste = (L *) lconcat(liste, secliste);
            secliste = NIL;
            /* calculate off-set */
            /* use the slow invert function for memory problems */
            /* help = (L *) Invert_Logic_S(liste); */
            /* fast but memory expensive function */
            help = (L *) Invert_Logic(liste);
            liste = (L *) clearlogic(liste); 
            liste = (L *) readlogic(argv[1]);
            if (argoff == 0) secliste = (L *) readlogic(argv[2]);
            else secliste = NULL;
            /* minimize */
            liste = (L *) Min_ES(liste,secliste,help,1);
            clearlogic(help);
            }
         /* process Quine */   
         else if ((alg > 0) && (errorg == 0))
            {
            /* concat lists */
            liste = (L *) lconcat(liste, secliste);
            secliste = NIL;
            /* minimize */
            liste = (L *) Min_Q(liste , (alg - 1) , 1, 1);
            }
         else printf("wrong arguments\n");          
         if ((itera > 0) && (errorg == 0))
            {
            tablist = (L *) readlogic(argv[1]);
            if (!strcmp(argv[5 - argoff], "a")) itera = ((llength(liste)) / 2) + 1; 
            printf("\nnumber of primetab iterations : %i",itera);
            liste = (L *) Min_Prime_Tab(liste, tablist, itera);
            }   
         if (errorg == 0)
            {
            /* stop timer */  
            time2 = clock();        
            /* write out result */
            writelogic(argv[3 - argoff],liste);
            printf("\ntime for execution: %10.3f sec\n", \
               (float) (time2-time1)/CLOCKS_PER_SEC);
            }   
         secliste = (L *) clearlogic(secliste);      
         liste = (L *) clearlogic(liste);
         }              
      } 
   /* give help for wrong arguments */   
   else 
      {
      printf("wrong arguments\n"); 
      printf("\nsyntax [-h | -v | on-set-file [dc-set-file]");
      printf(" out-file proc primetab]\n\n");
      printf("  -h  this helpscreen\n");
      printf("  -v  version information\n\n");
      printf("  proc = 0     : Espresso-Signature\n");
      printf("  proc = 1     : full Quine\n");
      printf("  proc > 1     : number of Quine iterations\n\n");
      printf("  primetab = 0 : primetab off\n");
      printf("  primetab > 0 : number of primtab iterations\n");
      printf("  primetab = a : autoiterate\n\n");
      }
   exit(0);
   }
   
