/*###########################################################################
type:             header file logic.h
funkcion:         functions for logic minimize
Project:          diplom
Programmierer:    Mario Hahnemann 
Organisation:     IA/Fak f. techn. & theoretische Informatik
                  Technische Universitaet Ilmenau
first version   : 22.03.1998
@UPDATE_1 	: 10.02.1999
@UPDATE_2	: 24.10.1999
#############################################################################*/

#ifndef __LOGIC_MIN
#define __LOGIC_MIN

#include "list.h"
#include "time.h"
#include "unistd.h"
#include <sys/types.h>
#include <sys/wait.h>

typedef struct rettype
   {
   UINT back;
   listptr cube;
   } ret;

typedef ret *retptr;   

/*---------------------------------------------------------------------------
foreach element of in Ausdr1 with each in Ausdr2 calculate a + ab = a
-----------------------------------------------------------------------------*/
extern void *Streich(listptr Ausdr1, listptr Ausdr2);

/*---------------------------------------------------------------------------
foreach element of in Ausdr1 with each in Ausdr2 calculate ac + ~ab = cb 
-----------------------------------------------------------------------------*/
extern void *Prim(listptr Ausdr1, listptr Ausdr2);         

/*---------------------------------------------------------------------------
add the results of Prim of all Element with all the other to liste
-----------------------------------------------------------------------------*/
extern void *Add_Prim(listptr liste);

/*---------------------------------------------------------------------------
test all elements of liste with the other if the is an result of Streich
if there is an result it delete one of the matching elements
-----------------------------------------------------------------------------*/      
extern void *Del_Alternate(listptr liste);
   
/*---------------------------------------------------------------------------
delete all elements in liste1 that are covert from an element in liste2
-----------------------------------------------------------------------------*/
extern void *Del_Equal(listptr liste1, listptr liste2);
  
/*---------------------------------------------------------------------------
main function for the quine methode- minimize Ausdr an number of iterations
(0 for full optimizion) 
part: values from 0 (off) to 2 (all on) for clustering (performance anhance,
try it)
for output = 1 you get status informations 0 for none
-----------------------------------------------------------------------------*/
extern void *Min_Q(listptr Ausdr, unsigned int iteration, \
   UINT part, UINT output);
        
/*---------------------------------------------------------------------------
sorts li for the # of don't cares
-----------------------------------------------------------------------------*/
extern void *Sort_DC(listptr li);

/*-------------------------------------------------------------------------- 
cover test
----------------------------------------------------------------------------*/
extern retptr Expand_Part(listptr Ausdr, listptr liste);

/*---------------------------------------------------------------------------
delete redundant prime cubes (on-set without don't cares)
-----------------------------------------------------------------------------*/
extern void *Prime_Tab(listptr Min, listptr Ausdr);
   
/*---------------------------------------------------------------------------
better but slower - same as Prime Tab (on-set with dont cares)
-----------------------------------------------------------------------------*/
extern void *Prime_Tab_V(listptr Min, listptr Ausdr);

/*---------------------------------------------------------------------------
arrange the elements in list new with an random algorithm
-----------------------------------------------------------------------------*/
extern void *Random_Sort(listptr liste);

/*---------------------------------------------------------------------------
returns a list of all cubes for varcount vars (without don't cares
-----------------------------------------------------------------------------*/ 
extern void *Expand_All(unsigned int varcount);
   
/*---------------------------------------------------------------------------
search the first DC var in Ausdr an return a pointer to it
-----------------------------------------------------------------------------*/   
extern UINT *Find_DC(listptr Ausdr);
   
/*---------------------------------------------------------------------------
invert liste
-----------------------------------------------------------------------------*/
extern void *Invert_Logic(listptr liste);
   
/*--------------------------------------------------------------------------- 
faster version 
-----------------------------------------------------------------------------*/  
extern void *Invert_Logic_S(listptr liste);

/*---------------------------------------------------------------------------
only the var on position pos is an non don't care var with selected value
-----------------------------------------------------------------------------*/
extern void *Single_Value_Ulist(UINT value, unsigned int pos);

/*---------------------------------------------------------------------------
return a list who is the invertation of Ausdr
-----------------------------------------------------------------------------*/
extern void *Single_Invert_Logic(listptr Ausdr);

/*---------------------------------------------------------------------------
invert the values in Ausdr only
-----------------------------------------------------------------------------*/   
extern void *Binary_Invert(listptr Ausdr);

extern void *And_Single_Value(listptr Ausdr1, listptr Ausdr2);
   
extern void *Same_Value(listptr Ausdr1, listptr Ausdr2);
   
extern void *And_Value(listptr liste1, listptr liste2);
   
/*---------------------------------------------------------------------------
Blocking function on ESPRESSO Signature  
-----------------------------------------------------------------------------*/ 
extern void *Blocking(listptr Ausdr, listptr liste);

/*---------------------------------------------------------------------------
Sigma function of ESPRESSO Signature
-----------------------------------------------------------------------------*/
extern void *Sigma(listptr Ausdr, listptr liste);

/*---------------------------------------------------------------------------
tests if liste covers Ausdr
-----------------------------------------------------------------------------*/
extern UINT Part_of(listptr Ausdr, listptr liste);
  
/*----------------------------------------------------------------------------
is Ausdr element of liste ?
------------------------------------------------------------------------------*/
extern UINT Element_In(listptr Ausdr, listptr liste);

/*---------------------------------------------------------------------------
essential test
-----------------------------------------------------------------------------*/
extern retptr Ess_Test(listptr Ausdr, listptr DC, listptr Off);

/*--------------------------------------------------------------------------- 
ESPRESSO Signature 
minimize Ausdr with the don't care set DC and the off set Off
for output = 1 you get status information 0 for none
-----------------------------------------------------------------------------*/
extern void *Min_ES(listptr Ausdr, listptr DC, listptr Off, UINT output);
   
/*---------------------------------------------------------------------------
Prime Tab of Min
Ausdr is the initial on set
the process iterate the result, you can specify how often
-----------------------------------------------------------------------------*/
extern void *Min_Prime_Tab(listptr Min, listptr Ausdr, unsigned int Itera);

#endif
