/*###########################################################################
type:             Header Datei logic.h
function:         logic minimize
project:          diplom
programer:        Mario Hahnemann 
organisation:     IA/Fak f. techn. & theoretische Informatik
                  Technische Universitaet Ilmenau
first version   : 22.03.1998
@UPDATE_1 	: 10.02.1999
@UPDATE_2	: 24.10.1999
#############################################################################*/

#include "logic.h"
#include "list.h"
#include "time.h"
#include "unistd.h"
#include <sys/types.h>
#include <sys/wait.h>

unsigned int Max = 0;

void *Streich(listptr Ausdr1, listptr Ausdr2)
   {
   listptr erglist = NULL;
   UINT Wert1, Wert2;
   UINT *erg;
   unsigned int w1 = 0;
   unsigned int w2 = 0;
   if (Max == 0) Max = llength(Ausdr1) - 1;	
   for (register unsigned int Index = 0; Index <= Max; Index++)
      {
      /* gets new element */    	
      erg = (UINT *) mallocs(sizeof(UINT));
      /* load both logic values */
      Wert1 = *((UINT *) lindex(Ausdr1,Index));
      Wert2 = *((UINT *) lindex(Ausdr2,Index));
      /* if both dont care */
      if ((Wert1 == 2) && (Wert2 == 2))
         {
         *erg = 2;
         } 
      else 
         {
         *erg = Wert1;       
         /* if one of the variables dont care, then erg dont care */ 
         if (Wert1 == 2)
            {
            *erg = 2;
            Wert2 = 2;
            /* set DC counter if dont cares in both logic expressions */
            w1++;
            }
         /* same test for Wert2 */
         else if (Wert2 == 2)
            {
            *erg = 2;
            Wert1 = 2;
            w2++;
            }         
         }
      /* test if dont cares on both expressions, or not equal on one position*/
      if (((w1 != 0) && (w2 != 0)) || (Wert1 != Wert2))
         {
         erglist = (L *) lreplace_a(erglist);
         frees(erg);
         break;
         } else {
         /* else insert new element */
         erglist = (L *) linsert(erglist,Index,erg);
         }        
      } 
   return(erglist);   
   }
   
void *Prim(listptr Ausdr1, listptr Ausdr2)
   {
   listptr erglist = NULL;
   UINT Wert1, Wert2;
   UINT *erg;
   unsigned int count = 0;
   if (Max == 0) Max = llength(Ausdr1) - 1;
   /* for all elements in sub list */
   for (register unsigned Index = 0; Index <= Max; Index++)
      {
      /* get new element */
      erg = (UINT *) mallocs(sizeof(UINT));
      /* load logic values */
      Wert1 = *((UINT *) lindex(Ausdr1,Index));
      Wert2 = *((UINT *) lindex(Ausdr2,Index));
      /* special case both dont cares */
      if ((Wert1 == 2) && (Wert2 == 2))
         {
         *erg = 2;
         } 
      else 
         {
         if (Wert1 == 2) *erg = Wert2;
         else if (Wert2 == 2) *erg = Wert1;
         /* one is the invers of the other value */
         else if (Wert1 != Wert2)
            {
            /* increase dont care counter */
            count++;
            *erg = 2;
            }
         /* must be equal */
         else *erg = Wert1;   
         }   
      /* insert new element */ 
      erglist = (L *) linsert(erglist,Index,erg);
      /* if more than dont care */
      if (count > 1) break;   
      }
   /* test if the is a konsensus */
   if ((count == 0) || (count > 1))
      {
      /* delete list */
      erglist = (L *) lreplace_a(erglist);
      }  
   return(erglist);   
   }
         
void *Add_Prim(listptr liste)
   {
   listptr buffer, mark;
   listptr erglist = NULL;
   /* calculate list length */
   unsigned int MaxIndex = llength(liste) - 1;
   /* for all elements in liste */
   for (register unsigned int Index1 = 0; Index1 < MaxIndex; Index1++)
      {
      /* sav list element */
      buffer = (L *) lindex(liste,Index1);
      /* for all elements other list */ 
      for (register unsigned int Index2 = Index1 + 1; Index2 <= MaxIndex; Index2++)
         {
	 /* konsensus between N und N+1 */
         mark = (L *) Prim(buffer,(L *) lindex(liste,Index2));
	 /* if exist konsensus insert in erglist */
         if (mark != NULL) erglist = (L *) linsert(erglist,0,mark);
         }
      }
   /* insert in new list */
   erglist = (L *) lconcat(liste, erglist);
   return(erglist);
   }

void *Del_Alternate(listptr liste)
   {
   listptr buffer, mark, mem;
   listptr erglist = NULL;
   mark = NULL;
   if (liste == NULL) return(NULL);
   /* get list length */
   unsigned int MaxIndex = llength(liste) - 1;
   /* for all list elements */
   for (register unsigned int Index1 = 0; Index1 <= MaxIndex; Index1++)
      {
      /* save element N */
      buffer = (L *) lindex(liste, Index1);
      /* for all elements after N */
      for (register unsigned int Index2 = Index1 + 1; (Index2 <= MaxIndex); Index2++)
         {
         /* save N+1 */
         mem = (L *) lindex(liste, Index2);
         /* try to discard N+1 or N */
         mark = (L *) Streich(buffer,mem);
         /* if not NULL than eraseable*/
         if (mark != NULL)
            {
            /* discard N */
            lreplace_a(buffer);
            /* insert new element on position N*/
            buffer = mark;
            /* discard N+1 */
            lreplace_a(mem);
            /* discard head N+1 from liste */
            liste = (L *) lreplace(liste, Index2);
            if (liste == NULL) break;
            /* correct indexes */
            MaxIndex--;
            Index2--;
            }
         }
      /* put in erglist */
      erglist = (L *) linsert(erglist,0,buffer);
      if (liste == NULL) break;
      }
   /* discard heads */
   while (liste != NULL)
      {
      mark = liste;
      liste = mark->P2L;
      frees(mark);
      }
   return(erglist);       
   }   

void *Del_Equal(listptr liste1, listptr liste2)
   {
   listptr buffer, mem;
   listptr mark = NULL;
   /* get both length */
   if (liste1 == NULL) return(NULL);
   unsigned int MaxIndex1 = llength(liste1) - 1;
   unsigned int MaxIndex2 = llength(liste2) - 1;
   /* for all elements of list */
   for (register unsigned int Index1 = 0; Index1 <= MaxIndex1; Index1++)
      {
      /* get first element in fist list*/
      buffer = (L *) lindex(liste1, Index1);
      /* for all in second list */
      for (register unsigned int Index2 = 0; Index2 <= MaxIndex2;  Index2++)
         {
         mem = (L *) lindex(liste2, Index2);
         /* get alternates */
         mark = (L *) Streich(buffer,mem);
         /* alternates exist ? */
         if (mark != NULL)
            {
            lreplace_a(buffer);
            liste1 = (L *) lreplace(liste1, Index1);
            lreplace_a(mark);
            if (liste1 == NULL) break;
            MaxIndex1--;
            Index1--;
            }   
         }
      if (liste1 == NULL) break;  
      }
   return(liste1);       
   }
   
void *Min_Q(listptr Ausdr, unsigned int iteration, \
	UINT part, UINT output)
   {
   listptr buffer1 = Ausdr;
   listptr buffer2; 
   unsigned int pass = 0;
   if (Max == 0) Max = llength((L *) lindex(Ausdr, 0)) - 1;
   if (/* (Max > 1) && */(llength(buffer1) > 1))
      {
      /* set maximum iteration */
      if (iteration == 0) iteration = 0xffff;
      /* get status */
      if (output == 1) 
         {
         printf("input file:\n");
         printf("     number of variables: %d\n",(Max + 1));
         printf("    number of implikants: %d\n\n", llength(buffer1));
         }
      /* activate dont care sort */
      if ((part & 0x01) == 1) buffer1 = (L *) Sort_DC(buffer1);
      /* delete alternates */
      buffer1 = (L *) Del_Alternate(buffer1);
      do
         {
         if (output == 1) printf("Pass %d : size of logic %d \n",pass, \
            llength(buffer1));
         /* copy list */
         buffer2 = (L *) lcopy(buffer1);
         /* activate dont care sort */
         if ((part & 0x02) == 0x02) buffer1 = (L *) Sort_DC(buffer1);
         /* get konsensus */ 
         buffer1 = (L *) Add_Prim(buffer1);
         if (llength(buffer1) > 1)
            {
            if ((part & 0x01) == 0x01) buffer1 = (L *) Sort_DC(buffer1);
            /* delete alternates */
            buffer1 = (L *) Del_Alternate(buffer1);
            } 
         else 
            {
            break;
            }
         /* count pass */ 
         pass++;
         iteration--;   
         }   
      while((!(lcomp_a(buffer1, buffer2))) && (iteration != 0));   
      }   
   if (output == 1) printf("Optimize stops at Pass %d : size at the end %d\n", \
           pass, llength(buffer1));
   return(buffer1);   
   }  
 
void *Sort_DC(listptr li)
   {
   listptr buffer;
   listptr erg = NULL;
   register unsigned int count = 0;
   register unsigned int index = 0;
   while (li != NULL)
      {
      /* test if actual dont care count */
      do
         {
         buffer = (L *) lindex(li,index);
         /* if its the correct dont care count */
         if (count == Count_DC(buffer))
            {
            /* insert new in buffer */
            erg = (L *) linsert(erg, 0, buffer);
            /* delete old */
            li = (L *) lreplace(li,index);
            } 
         else 
            {
            /* else set index only */
            index++;   
            }
         }
      while((index < llength(li)) && (li != NULL));
      index = 0; 
      /* count up dont care count */  
      count++;   
      }
   return(erg);   
   }   

retptr Expand_Part_Rek(listptr Ausdr, listptr liste, unsigned int DC, \
   	listptr helplist)
   {
   retptr test1 = NULL;
   retptr test2 = NULL;
   retptr erg = (ret *) mallocs(sizeof(ret));
   erg->back = 0;
   erg->cube = NULL;
   DC--;
   /* try to remove elements */
   listptr neu = (L *) Streich(Ausdr, liste);
   /* if no success new recursion */
   if (neu == NULL)
      {
      /* if there is a DC list expand */
      if (DC != 0)
         {
         listptr neu1 = (L *) lcopy_u(Ausdr);
         listptr neu2 = (L *) lcopy_u(Ausdr);
         UINT *element1 = Find_DC(neu1);
         *element1 = 0;
         UINT *element2 = Find_DC(neu2);
         *element2 = 1;
         /* expand for both sub trees */
         test1 = Expand_Part_Rek(neu1, liste, DC, helplist);
         test2 = Expand_Part_Rek(neu2, liste,DC, test1->cube);
         helplist = test2->cube;
         /* add cuted list to erg */
         if ((test1->back == 1) && (test2->back == 0))
            {
            helplist = (L *) linsert(helplist,0,neu2);
            lreplace_a(neu1); 
            erg->back = 1;
            }
         else if ((test2->back == 1) && (test1->back == 0))
            {
            helplist = (L *) linsert(helplist,0,neu1);
            lreplace_a(neu2);
            erg->back = 1;
            }
         else
            {
            if ((test1->back == 1) && (test2->back == 1)) erg->back = 1;
            lreplace_a(neu1);
            lreplace_a(neu2);
            }   
         }
      }
   else
      {
      /* if delete success then return from recursion */
      erg->back = 1;
      lreplace_a(neu);
      }
   if (test1 != NULL) frees(test1);
   if (test2 != NULL) frees(test2);
   erg->cube = helplist;
   return(erg);
   }

retptr Expand_Part(listptr Ausdr, listptr liste)
   {
   retptr test = NULL;
   if (Ausdr != NULL)
      {
      if (Max == 0) Max = llength(Ausdr) - 1;
      /* get DC count */
      unsigned int DC = Count_DC(Ausdr) + 1;
      if (DC > 0)
         {
         /* copy Ausdr */
         listptr mark = (L *) lcopy_u(Ausdr);
         /* call recurs part to expand */
	 test = Expand_Part_Rek(mark,liste,DC,NULL);
         lreplace_a(mark);
         }
      }   
   return(test);      
   }

void *Prime_Tab(listptr Min, listptr Ausdr)
   {
   listptr  buffer, element, test;
   bool optimize = false;  
   register unsigned int count1 = 0;
   register unsigned int count2 = 0;
   /* get list length */
   unsigned int maxele1 = llength(Min);
   unsigned int maxele2 = llength(Ausdr);
   /* do while all elements are tested */
   while (count1 < maxele1)
      {
      buffer = (L *) lindex(Min,count1);
      /* test with all elements from second list */
      while (count2 < maxele2)
         {
         element = (L *) lindex(Ausdr,count2);
         /* test if one alternate from other */
         test = (L *) Streich(buffer, element);
         if (test != NULL)
            {
	    /* delete alternate */
            lreplace_a(test);
            /* set marker */
            optimize = true;
            /* delete from Ausdr */ 
            lreplace_a(element);
            Ausdr = (L *) lreplace(Ausdr,count2);
            maxele2--;
            } 
         else count2++;
         }
      count2 = 0;
      /* if elelemnt from Min not in Ausdr */
      if (optimize != true)
         {
         /* remove from Min */
         lreplace_a(buffer);
         Min = (L *) lreplace(Min,count1);
         if (maxele1 != 0) maxele1--;
         } else {
         count1++;
         optimize = false;
         }
      }  
   return(Min);   
   }
   
void *Prime_Tab_V(listptr Min, listptr Ausdr)
   {
   listptr  buffer, element;
   retptr test;
   bool optimize = false;  
   register unsigned int count1 = 0;
   register unsigned int count2 = 0;
   unsigned int newlength = 0;
   /* get length of list */
   unsigned int maxele1 = llength(Min);
   unsigned int maxele2 = llength(Ausdr);
   /* do while all elements are tested */
   while (count1 < maxele1)
      {
      buffer = (L *) lindex(Min,count1);
      /* test with all elements */
      while (count2 < maxele2)
         {
         element = (L *) lindex(Ausdr,count2);
         test = Expand_Part(element, buffer);
         if (test->back == 1)
            {
            optimize = true;
            /* remove element */ 
            lreplace_a(element);
            Ausdr = (L *) lreplace(Ausdr,count2);
            maxele2--;
            /* add not covered elements */
            if (test->cube != NULL)
               {   
               newlength = llength(test->cube);
               Ausdr = (L *) lconcat(Ausdr, test->cube);
               maxele2 = maxele2 + newlength;
               }   
            } else {
            count2++;   
            }   
         frees(test);   
         }   
      count2 = 0;
      /* if tested element from Min not in Audr */
      if (optimize != true)
         {
         lreplace_a(buffer);
         Min = (L *) lreplace(Min,count1);
         if (maxele1 != 0) maxele1--;
         } else {
         count1++;
         optimize = false;
         }
      }  
   return(Min);   
   }    

void *Random_Sort(listptr liste)
   {
   listptr erglist = NULL;
   unsigned int index;
   /* get list length */
   register unsigned int count = llength(liste) - 1;
   srandom(clock());
   /* while liste is not empty */
   while(liste != NULL)
      {
      if (count != 0) 
         {
         /* get random number */
         index = random();
         /* nominate */
         index %= (count + 1);
         } 
      else index = 0;   
      /* get random element and copy */
      erglist = (L *) linsert(erglist, 0, (L *) lindex(liste,index));
      /* delete old list */
      liste = (L *) lreplace(liste,index);
      count--;
      }
   return (erglist);
   }      

void *uexpand(listptr liste1, listptr liste2, listptr erg, \
        	unsigned int varcount, unsigned int varind)
   {
   if ((liste1 == NULL) || (liste2 == NULL)) return(erg);
   varind++;
   varcount--;
   /* duplicate sub lists */
   listptr nlist1 = (L *) lcopy_u(liste1);
   listptr nlist2 = (L *) lcopy_u(liste2);
   /* make new heads */
   erg = (L *) linsert(erg, 0, nlist1);
   erg = (L *) linsert(erg, 0, nlist2);
   /* get new logic data */
   UINT *element1 = (UINT *) mallocs(sizeof(UINT));
   UINT *element2 = (UINT *) mallocs(sizeof(UINT));
   *element1 = 0;
   *element2 = 1;
   /* set in new elements */
   liste1 = (L *) linsert(liste1, varind, element1);
   nlist1 = (L *) linsert(nlist1, varind, element2);
   element1 = (UINT *) mallocs(sizeof(UINT));
   element2 = (UINT *) mallocs(sizeof(UINT));
   *element1 = 0;
   *element2 = 1;
   liste2 = (L *) linsert(liste2, varind, element1);
   nlist2 = (L *) linsert(nlist2, varind, element2);
   /* if new recursion */
   if (varcount > 0)
      {
      erg = (L *) uexpand(liste1, nlist1, erg, varcount, varind);
      erg = (L *) uexpand(liste2, nlist2, erg, varcount, varind);
      }
   return(erg);
   } 
 
void *Expand_All(unsigned int varcount)
   {
   listptr erg = NULL;
   if (varcount > 0)
      {
      /* make new logic data */
      UINT *element1 = (UINT *) mallocs(sizeof(UINT));
      UINT *element2 = (UINT *) mallocs(sizeof(UINT));
      /* set in logic values */
      *element1 = 0;
      *element2 = 1;
      listptr liste1 = NULL;
      listptr liste2 = NULL;
      liste1 = (L *) linsert(liste1, 0, element1);
      liste2 = (L *) linsert(liste2, 0, element2);
      erg = (L *) linsert(NULL, 0, liste1);
      erg = (L *) linsert(erg, 0, liste2);
      varcount--;
      if (varcount > 0)
         {
         /* new recursion */
         erg = (L *) uexpand(liste1, liste2, erg, varcount, 0);
         }   
      }
   return(erg);   
   }     
   
UINT *Find_DC(listptr Ausdr)
   {
   UINT *element = NULL;
   if (Max == 0) Max = llength(Ausdr) - 1;
   for (register unsigned int Index = 0; Index <= Max; Index++)
      {
      element = (UINT *) lindex(Ausdr, Index);
      if (*element == 2) break;
      }
   return(element);
   }
   
void *Invert_Logic(listptr liste)
   {
   if (Max == 0) Max = llength((L *) lindex(liste,0)) - 1;
   /* get all implikants who are possible with Max variables */
   listptr full_list = (L *) Expand_All(Max + 1);
   /* delete all elements in full_list who are covered by liste */
   listptr erg = (L *) Del_Equal(full_list, liste);
   return(erg);
   }
   
void *Invert_Logic_S(listptr liste)
   {   
   listptr buffer = NULL;
   if (liste != NULL)
      {
      listptr mark = NULL;   
      unsigned int length = llength(liste) - 1;
      buffer = (L *) lindex(liste, 0);
      if (length == 0)
         {
         /* if only one element to invert, build complement */
         buffer = (L *) lcopy_u(buffer);   
         buffer = (L *) Binary_Invert(buffer);
         mark = (L *) linsert(mark, 0, buffer);
         buffer = mark;
         } 
      else
         {
         listptr help1 = NULL;
         listptr help2 = NULL;
         /* build negate disjunction from buffer */
         buffer = (L *) Single_Invert_Logic(buffer);
         for (register unsigned int Index = 1; Index <= length; Index++)
            {
            help1 = buffer;
            mark = (L *) lindex(liste, Index);
            /* negate disjunction from mark */
            mark = (L *) Single_Invert_Logic(mark);
            help2 = mark;
            /* bind not conjunctions conjunktiv */
            if (buffer != NULL) buffer = (L *) And_Value(buffer, mark);
            else buffer = mark;   
            clearlogic(help1);
            clearlogic(help2);
            }   
         }   
      }
   buffer = (L *) Del_Alternate(buffer);   
   return(buffer);   
   }   

void *Single_Value_Ulist(UINT value, unsigned int pos)
   {
   listptr erg = NULL;
   if (pos <= Max)
      {
      bool insert = false;
      register unsigned int Index = Max + 1;
      UINT *element;
      pos = Max - pos;
      do
         {
         /* make new logic data */
         element = (UINT *) mallocs(sizeof(UINT));
         /* if we are on position insert the value */
         if ((pos == 0) && (insert == false))
            {
            *element = value;
            insert = true;
            } 
         else
            {
            *element = 2;       
            }
         /* insert new element */
         erg = (L *) linsert(erg, 0, element);
         pos--;
         Index--;
         }
      while(Index > 0);
      } 
   return(erg);   
   }   

void *Single_Invert_Logic(listptr Ausdr)
   {
   listptr erglist = NULL;
   listptr erg;
   if (Max == 0) Max = llength(Ausdr) - 1;
   /* special case length 0 */
   if (Max == 0)
      {
      erg = (L *) Binary_Invert(Ausdr);
      erglist = (L *) linsert(erglist, 0, erg);
      }
   else 
      {
      UINT value;
      UINT *element;
      for (register unsigned int Index = 0; Index <= Max; Index++)
         {
         /* poinre to element */
         element = (UINT *) lindex(Ausdr, Index);
         /* if not 2 then invert */
         switch (*element)
            {
            case 0: value = 1; break;
            case 1: value = 0; break;
            default: value = 2;
            }
         if (value != 2)
            {
            /* build fast single list */
            erg = (L *) Single_Value_Ulist(value, Index);
            /* and insert this */
            erglist = (L *) linsert(erglist, 0, erg);
            }
         }
      }
   return(erglist);
   }

void *Binary_Invert(listptr Ausdr)   
   {
   listptr erglist = NULL;
   UINT *element, value; 
   for (register unsigned int Index = Max + 1; Index > 0; Index--)
      {
      /* get pointer to element */
      element = (UINT *) lindex(Ausdr, (Index - 1));
      /* invert logic value */
      switch (*element) 
         {
         case 0: value = 1; break;
         case 1: value = 0; break;  
         default: value = 2;
         }   
      /* make new element */
      element = (UINT *) mallocs(sizeof(UINT));
      /* insert inverted value */
      *element = value;
      erglist = (L *) linsert(erglist, 0, element);
      }
   return(erglist);   
   }

void *And_Single_Value(listptr Ausdr1, listptr Ausdr2)
   {
   listptr erglist = NULL;
   UINT Wert1, Wert2;
   UINT *erg;
   unsigned int DC = 0;
   if (Max == 0) Max = llength(Ausdr1) - 1;
   for (register unsigned int Index = Max + 1; Index > 0; Index--)
      {
      /* make new element */
      erg = (UINT *) mallocs(sizeof(UINT));
      /* pointer to logic data */
      Wert1 = *((UINT *) lindex(Ausdr1,Index - 1));
      Wert2 = *((UINT *) lindex(Ausdr2,Index - 1));
      /* logic operation 2 & 2 = 2; 2 & 1 = 1; 2 & 0 = 0; 1 & 0 = 
         erase Ausdr */ 
      if (Wert1 == Wert2) 
         {
         *erg = Wert1;
         if (Wert1 == 2) DC++;
         } 
      else if (Wert1 == 2)
         {
         *erg = Wert2;
         } 
      else if (Wert2 == 2)
         {
         *erg = Wert1;
         } 
      else 
         {
         frees(erg);
         erglist = (L *) lreplace_a(erglist);
         break;
         }
      /* insert new element */
      erglist = (L *) linsert(erglist, 0, erg);
      } 
   /* if only dc variables */
   if (DC == (Max + 1)) erglist = (L *) lreplace_a(erglist);     
   return(erglist);   
   }   
   
void *Same_Value(listptr Ausdr1, listptr Ausdr2)
   {
   listptr erglist = NULL;
   UINT Wert1, Wert2;
   UINT *erg;
   unsigned int DC = 0;
   if (Max == 0) Max = llength(Ausdr1) - 1;
   for (register unsigned int Index = Max + 1; Index > 0; Index--)
      {
      /* make new logic data */
      erg = (UINT *) mallocs(sizeof(UINT));
      /* poiter to the logic data */
      Wert1 = *((UINT *) lindex(Ausdr1,Index - 1));
      Wert2 = *((UINT *) lindex(Ausdr2,Index - 1));
      /* logic operation 2 & 2 = 2; 2 & 1 = 2; 2 & 0 = 2; 1 & 1 = 1;
         0 & 0 = 0; 1 & 0 = 2 */
      if ((Wert1 == 2) || (Wert2 == 2)) 
         {
         *erg = 2;
         DC++;
         } 
      else if (Wert1 == Wert2)
         {
         *erg = Wert1;
         } 
      else 
         {
         *erg = 2;
         DC++;
         }
      /* insert new logic data */
      erglist = (L *) linsert(erglist, 0, erg);
      } 
   /* if only dc variables */
   if (DC == (Max + 1)) erglist = (L *) lreplace_a(erglist);     
   return(erglist);   
   }
   
void *And_Value(listptr liste1, listptr liste2)
   {
   listptr buffer, mark, erg;
   listptr erglist = NULL;
   /* get length of lists */
   unsigned int length1 = llength(liste1) - 1;
   unsigned int length2 = llength(liste2) - 1;
   /* evtl. Variablenanzahl ermitteln */
   if (Max == 0) Max = llength((L *) lindex(liste1, 0)) - 1;
   /* cross test all elements */
   for (register unsigned int Index1 = 0; Index1 <= length1; Index1++)
      {
      buffer = (L *) lindex(liste1, Index1);
      for (register unsigned int Index2 = 0; Index2 <= length2; Index2++)
         {
         mark = (L *) lindex(liste2, Index2);
         erg = (L *) And_Single_Value(buffer, mark);
         erglist = (L *) linsert(erglist, 0, erg);
         }
      }
   /* delete all alternates */
   erglist = (L *) Del_Alternate(erglist);
   return(erglist);   
   }
   
void *Blocking(listptr Ausdr, listptr liste)
   {
   listptr  erg, erglist, ulist;
   erglist = NULL;
   if (Max == 0) Max = llength(Ausdr) - 1;
   unsigned int length = llength(liste) - 1;
   /* make compliment */
   listptr compl = (L *) Binary_Invert(Ausdr);
   for (register unsigned int Index = 0; Index <= length; Index++)
      {
      /* test if value equal elements in complement */
      ulist = (L *) lindex(liste, Index);
      erg = (L *) Same_Value(compl, ulist);
      /* insert results */
      if (erg != NULL) erglist = (L *) linsert(erglist, 0, erg);
      }
   /* remove complement */   
   lreplace_a(compl); 
   /* delete alternates */
   erglist = (L *) Del_Alternate(erglist);
   return(erglist);
   }

void *Sigma(listptr Ausdr, listptr liste)
   {
   if (Max == 0) Max = llength(Ausdr) - 1;
   listptr buffer = NULL;
   /* call blocking */
   listptr erglist = (L *) Blocking(Ausdr, liste);
   if (erglist != NULL)
      {   
      unsigned int length = llength(erglist) - 1;
      buffer = (L *) lindex(erglist, 0);
      if (length == 0)
         {
         /* if result of blocking only one element, build complement */
         buffer = (L *) Binary_Invert(buffer);
         buffer = (L *) linsert(NULL, 0, buffer);
         } 
      else
         {
         /* build negate disjunction from buffer */
         buffer = (L *) Single_Invert_Logic(buffer);
         listptr help1, help2, mark;
         for (register unsigned int Index = 1; Index <= length; Index++)
            {
            help1 = buffer;
            mark = (L *) lindex(erglist, Index);
            /* negierte Disjunktion aus mark bilden */
            mark = (L *) Single_Invert_Logic(mark);
            help2 = mark;
            /* bind not conjunctions conjunktiv */
            if (buffer != NULL) buffer = (L *) And_Value(buffer, mark);
            else buffer = mark;   
            clearlogic(help1);
            clearlogic(help2);
            }
         }      
      clearlogic(erglist);
      }
   return(buffer);   
   }

UINT Part_of(listptr Ausdr, listptr liste)
   {
   UINT erg = 0;
   if ((liste != NULL) && Ausdr != NULL)
      {
      listptr mark, buffer;
      /* get length of list */
      unsigned int length = llength(liste) - 1;
      for (register unsigned int Index = 0; Index <= length; Index++)
         {
         buffer = (L *) lindex(liste, Index);
         /* try to find an alternate */
         mark = (L *) Streich(Ausdr, buffer);
         /* if the is an alternate with less than dc values */
         if (mark != NULL) 
            if (lcomp(mark,buffer))
               {  
               erg = 1;
               break;
               }
         lreplace_a(mark);   
         }
      }
   return(erg);   
   }
  
UINT Element_In(listptr Ausdr, listptr liste)
   {
   UINT erg = 0;
   if ((liste != NULL) && (Ausdr != NULL))
      {
      /* get list length */
      unsigned int length = llength(liste) - 1;
      listptr mark;
      /* check all elements */
      for (register unsigned int Index = 0; Index <= length; Index++)
         {
         mark = (L *) lindex(liste, Index);
         /* compare Ausdr with mark */
         erg = lcomp(Ausdr, mark);
         if (erg == 1) break;
         }
      }
   return(erg);   
   }   

retptr Ess_Test_Rec(listptr Ausdr, listptr Mark, listptr DC, listptr Off, \
        	UINT DC_Anz)
   {
   retptr erg;
   /* test if Mark in external dont care set */
   if (Part_of(Mark, DC))
      {
      erg = (ret *) mallocs(sizeof(ret));
      erg->back = 0;
      erg->cube = NULL;
      }
   /* if not dont care variables, end of recursion */
   else if (DC_Anz == 0)
      {
      erg = (ret *) mallocs(sizeof(ret));
      /* get Sigma */
      listptr sig = (L *) Sigma(Mark, Off);   
      if (Element_In(Ausdr, sig))
         {
         erg->back = 1;
         clearlogic(sig);
         erg->cube = NULL;
         } 
      else
         /* FALSE and Sigma back */
         {
         erg->back = 0;
         erg->cube = sig;
         }
      }
   /* there are dont cares new recursion */   
   else 
      {
      DC_Anz--;
      erg = (ret *) mallocs(sizeof(erg));
      /* find first dont care variable in Ausdr and set FALSE */
      UINT *element = Find_DC(Mark);
      *element = 0;
      /* make recursion */
      retptr erg1 = Ess_Test_Rec(Ausdr, Mark, DC, Off, DC_Anz);
      retptr erg2 = NULL;
      /* if result FALSE ist, then follow TRUE tree of dont care variable */
      if (erg1->back == 0)
         {
         *element = 1;
         /* new recursion */
         erg2 = Ess_Test_Rec(Ausdr, Mark, DC, Off, DC_Anz);
         /* if both recursions FALSE then bind Sigma */
         if (erg2->back == 0)
            {
            erg->back = 0;
            if (erg1->cube == NULL) erg->cube = erg2->cube;
            else if (erg2->cube == NULL) erg->cube = erg1->cube;
            else 
               {
               erg->cube = (L *) lconcat(erg1->cube, erg2->cube);
               /* delete alternates */
               erg->cube = (L *) Del_Alternate(erg->cube);
               } 
            } 
         else
            {
            erg->cube = erg2->cube;
            erg->back = erg2->back;
            }
         } 
      else
         {
         erg->cube = erg1->cube;
         erg->back = erg1->back;
         }   
      if (erg1 != NULL) frees(erg1);
      if (erg2 != NULL) frees(erg2);
      *element = 2;     
      }      
   return(erg);
   }   

retptr Ess_Test(listptr Ausdr, listptr DC, listptr Off)
   {
   /* copy Ausdr because origin will be changed */
   listptr Mark = (L *) lcopy_u(Ausdr);
   /* count DC variables */
   unsigned int DC_Anz = Count_DC(Ausdr);
   /* make recursion */
   retptr erg = Ess_Test_Rec(Ausdr, Mark, DC, Off, DC_Anz);
   /* delete test element */
   lreplace_a(Mark);
   return(erg);
   }

void *Min_ES(listptr Ausdr, listptr DC, listptr Off, UINT output)
   {
   listptr erg = NULL;
   retptr test = NULL;
   listptr EDC = NULL;
   if (DC != NULL) EDC = (L *) lcopy(DC);
   if (Max == 0) Max = llength((L*) lindex(Ausdr,0)) - 1;
   if (output == 1)
      {
      printf("in file:\r\n");
      printf("         number of variables: %d\r\n",(Max + 1));
      printf("       number of implikation: %d\r\n\r\n", llength(Ausdr));
      }
   if (Off == NULL)
      {
      UINT *element;
      unsigned int Index = Max + 1;
      do
         {
         /* make new element */
         element = (UINT *) mallocs(sizeof(UINT));
         *element = 2;
         erg = (L *) linsert(erg, 0, element);
         Index--;
         }
      while(Index > 0);
      erg = (L *) linsert(NULL, 0, erg);
      }
   else
      {
      listptr buffer;
      while (Ausdr != NULL)
         {
         /* pointer to first element of Ausdr */
         buffer = (L *) lindex(Ausdr, 0);
         /* test, if essentiell */
         test = Ess_Test(buffer, DC, Off);
         /* if essentiell */
         if (test->back == 1)
            {
            EDC = (L *) linsert(EDC, 0, (L *) lcopy_u(buffer));
            erg = (L *) linsert(erg, 0, buffer);
            Ausdr = (L *) lreplace(Ausdr, 0);
            } 
         else
            {
            lreplace_a(buffer);
            Ausdr = (L *) lreplace(Ausdr, 0);
            /* if new Sigma, add to Ausdr */
            if (test->cube != NULL) Ausdr = (L *) lconcat(test->cube,Ausdr);
            /* delete alternatives */
            Ausdr = (L *) Del_Alternate(Ausdr);
            }
         /* if help elements empty */
         if (test != NULL) frees(test);
         test = NULL;
         }
      if (output == 1)
         {
         printf("       length after minimize: %d\r\n", llength(erg));
         }
      clearlogic(EDC);
      }
   return(erg);
   }   
   
void *Min_Prime_Tab(listptr Min, listptr Ausdr, unsigned int Itera)
   {
   listptr listcopy;
   printf("\nlength of minterm: %d\n", llength(Min)); 
   while (Itera != 0)
      {
      /* copy origin */
      listcopy = (L *) lcopy(Ausdr);
      /* sort by number of DC in elements */
      Min = (L *) Sort_DC(Min);
      Min = (L *) Prime_Tab_V(Min, listcopy);
      /* randomize */
      Min = (L *) Random_Sort(Min);
      Itera--;
      }   
   clearlogic(Ausdr);   
   printf("length after primetab: %d\n",llength(Min));     
   return(Min);
   }

