/*###########################################################################
type:             header file list.h
function:         handle logic lists
project:          diplom
programer:        Mario Hahnemann 
Organisation:     IA/Fak f. techn. & theoretische Informatik
                  Technische Universitaet Ilmenau
first version   : 22.03.1998
@UPDATE_1	: 24.10.1999
#############################################################################*/
#ifndef __LOG_LIST
#define __LOG_LIST


#include "stdlib.h"
#include "stdio.h"

/* im pascal progamer too */
#define NIL NULL

/*---------------------------------------------------------------------------
MAXSIZE defines the maximum length of vars and lists
-----------------------------------------------------------------------------*/
#define MAXSIZE 0xFFFF

#define UINT unsigned char

/*---------------------------------------------------------------------------
an logic set is an two dimensional list
-----------------------------------------------------------------------------*/
typedef struct L {
   L *P2L;      /* Pointer auf das naechste Element einer Logikliste */
   void *Data;  /* Pointer auf eine Unterliste oder einen Logikwerteintrag */
   } liste;

typedef L *listptr;


#define SUCCESS 0
#define NOT_EXIST 1
#define EMPTY 2
#define BAD_FILE 3

extern UINT fileerror;

/* memcount vars for debuging */

extern unsigned int Memcount_a;
extern unsigned int Memcount_f;

/* memory test and allocation */

extern void *mallocs(size_t size);
  
extern void frees(void *mem);

/*---------------------------------------------------------------------------
gives true if list1 and list2 are identical
-----------------------------------------------------------------------------*/
extern UINT lcomp(listptr list1, listptr list2);

/*--------------------------------------------------------------------------- 
gives an index of an element in li
-----------------------------------------------------------------------------*/  
extern void *lindex(listptr li, unsigned int element);

/*--------------------------------------------------------------------------- 
insert an element in li on position element
-----------------------------------------------------------------------------*/
extern void *linsert(listptr li, unsigned int element, void *ptr2ele);

/*---------------------------------------------------------------------------
erase the element in li
-----------------------------------------------------------------------------*/
extern void *lreplace(listptr li, unsigned int element);

/*---------------------------------------------------------------------------
full erase of an one dimensional list 
-----------------------------------------------------------------------------*/
extern void *lreplace_a(listptr li);
      
/*---------------------------------------------------------------------------
reads an file and save the contained data to an two dimensional list
format:
e.g.
   011001
   200120
   012002
every line have the syntax:
   Bit1Bit2Bit3...
the Bits are connected with logical AND
  - Tab and white spaces are not supported
  - every line ends with '\n'
  - all non komment lines have the same length
  - komments begin with '#'
  - you can use empty lines (non tested)
  - the lines are similar to the cube definition
------------------------------------------------------------------------------*/   
extern void *readlogic(char *filename);

/*---------------------------------------------------------------------------
writes the full logic list
-----------------------------------------------------------------------------*/
extern void writelogic(char *filename,listptr li);

/*---------------------------------------------------------------------------
erase a two dimensional list
-----------------------------------------------------------------------------*/
extern void *clearlogic(listptr li);
   
/*---------------------------------------------------------------------------
returns the length of li
-----------------------------------------------------------------------------*/
extern unsigned int llength(listptr li);

/*---------------------------------------------------------------------------
concat the lists li1 and li2
-----------------------------------------------------------------------------*/
extern void *lconcat(listptr li1, listptr li2);

/*---------------------------------------------------------------------------
tests if Ausdr1 and Ausdr2 contains the same elements (destructs Ausdr2 !)
-----------------------------------------------------------------------------*/ 
extern UINT lcomp_a(listptr Ausdr1, listptr Ausdr2);

/*--------------------------------------------------------------------------- 
copy an two dimensional list
-----------------------------------------------------------------------------*/
extern void *lcopy(listptr Ausdr);
   
/*---------------------------------------------------------------------------
copy an one dimensional list
-----------------------------------------------------------------------------*/
extern void *lcopy_u(listptr liste);
   
/*---------------------------------------------------------------------------   
count the don't cares in a one dimensional list
-----------------------------------------------------------------------------*/
extern unsigned int Count_DC(listptr li);

#endif
