/*###########################################################################
type:             c++ file list.h
function:         handle logic lists
project:          diplom
programer:        Mario Hahnemann 
organisation:     IA/Fak f. techn. & theoretische Informatik
                  Technische Universitaet Ilmenau
first version:    22.03.1998
@UPDATE_1:	  24.10.1999
#############################################################################*/

#include "stdlib.h"
#include "stdio.h"
#include "list.h"


UINT fileerror;

unsigned int Memcount_a;
unsigned int Memcount_f;

void *mallocs(size_t size)
   {
   Memcount_a++;
   void *ret = malloc(size);  
   if (ret == NULL)      
      {
      printf("no memory left");
      exit(0);
      }
   return(ret);
   }
   
void frees(void *mem)
   {
   Memcount_f++;
   free(mem);
   }   

UINT lcomp(listptr list1, listptr list2)
    {
    while ((list1 != NULL) && (list2 != NULL))
       {
       /* compare if elements equal */
       if (*((UINT *) list1->Data) != *((UINT *) list2->Data)) 
          {
          return(0);
          }
       /* set pointer to sub element */   
       list1 = (L *) list1->P2L;
       list2 = (L *) list2->P2L;
       }
    /* if not equal set to false */
    if ((list1 != NULL) || (list2 != NULL)) return(0);
    /* return logic value */
    return(1);   
    }

void *lindex(listptr li, unsigned int element)
   {
   register unsigned int count = 0;
   /* do while not list end and not maxsize */
   while ((count < MAXSIZE) && (li != NULL)) 
      {
      /* already on element */
      if (count == element) 
         {
         break;
         } 
      else 
         {
         /* load next list element */
         count++;
         li = li->P2L;
         }   
      }
   /* pointer to found element, NULL for error */   
   return(li->Data);
   }

void *linsert(listptr li, unsigned int element, void *ptr2ele)
   {
   listptr mark;
   /* save origin */
   listptr oldptr = li;
   listptr last = li;
   /* special case first element */
   if ((element == 0) && (ptr2ele != NULL))
      {
      /* get memory */
      oldptr = (L *) mallocs(sizeof(liste));
      /* save old pointer in new element */
      oldptr->P2L = li;
      oldptr->Data = ptr2ele;
      } 
   else 
      {
      register unsigned int count = 1;
      while ((count < MAXSIZE) && (li != NULL))
         {
         /* set li to next element*/
         li = li->P2L;
         /* allready on forced element */
         if (count == element) 
            {
            /* save old element */
            mark = li;
            /* get memory */
            li = (L *) mallocs(sizeof(liste));
            /* set in old list */
            last->P2L = li;
            /* set data to new element */
            li->Data = ptr2ele;
            li->P2L = mark;
            break;
            }
         count++;
         /* set to next */
         last = last->P2L;
         }
      }
   /* pointer to changed list */      
   return(oldptr);   
   }

void *lreplace(listptr li, unsigned int element)
   {
   if (li == NULL) return(NULL);
   listptr oldptr = li;
   listptr last = li;
   /* special case first element */
   if (element == 0)
      {
      /* sav next element */
      oldptr = li->P2L;
      /* free element */
      frees(li);
      /* no special case */
      } 
   else 
      {
      register unsigned int count = 1;
      while ((count < MAXSIZE) && (li != NULL))
         {
         /* set li to next element */
         li = li->P2L;
         /* if on forced element */
         if (count == element) 
            {
            /* include next element */
            last->P2L = li->P2L;
            /* delete element */
            frees(li);
            break;
            }
         count++;
         /* select next element */
         last = last->P2L;
         }
      }
   /* pointer to changed list */      
   return(oldptr);   
   }

void *lreplace_a(listptr li)
   {
   listptr mark;
   /* continue while not end of list */
   while (li != NULL)
      {
      /* sav element */
      mark = li;
      /* set li to next */
      li = li->P2L;
      /* delete logic data */
      if (mark->Data != NULL) frees(mark->Data);
      /* delete element */
      frees(mark);
      }   
   return(NULL);   
   }
      
void *readlogic(char *filename)
   {
   /* i need a better reader (with lex for instance), but this one runs */
   FILE *infile;
   char wert[2];
   char *mode = "r";
   listptr ulist;
   listptr li = NULL;
   wert[1] = '\n';
   wert[0] = 0;
   UINT *element;
   listptr list, mark;
   list = NULL;
   mark = NULL;
   fileerror = SUCCESS;
   infile = fopen(filename,mode);
   /* if success */
   if (infile != 0x00)
      {
      /* if no EOF */
      wert[0] = getc(infile);
      if (wert[0] == '#') 
         {
         while ((wert[0] != '\n') && (wert[0] != -1)) wert[0] = getc(infile);
         wert[0] = getc(infile);
         }
      else if ((wert[0] == -1) || (wert[0] == '\n')) fileerror = EMPTY;
      else if (!((wert[0] == '1') || (wert[0] == '0'))) 
         if (!((wert[0] == '2') || (wert[0] == '\n'))) fileerror = BAD_FILE;
      while((wert[0] != -1) && (fileerror == SUCCESS))
         {
         ulist = NULL;
         /* if not end of line and file */
         while((wert[0] !=  '\n') && (wert[0] != -1))
            {
            /* get new element */
            element = (UINT  *) mallocs(sizeof(UINT));
            /* convert to integer */
            *element = atoi(wert);
            /* special case first value in list */
            if (ulist == NULL)
               {
               /* new sub list */
               ulist = (L *) mallocs(sizeof(liste));
               /* write data */
               ulist->Data = (void *) element;
               mark = ulist;
               } 
            else 
               {
               /* if not first */
               mark->P2L = (L *) mallocs(sizeof(liste));
               /* insert new element */
               mark = mark->P2L;
               /* write data */
               mark->Data = (void *) element;
               }
            /* read new value */   
            wert[0] = getc(infile);
            if (!((wert[0] == '1') || (wert[0] == '0') || (wert[0] == -1)))
               if (!((wert[0] == '2') || (wert[0] == '\n'))) fileerror = BAD_FILE;
            }   
         mark->P2L = NULL;  
         /* if we have a new sub list */ 
         if (ulist != NULL) 
            {
            /* if no list */
            if (li == NULL)
               {
               /* get new element */
               li = (L *) mallocs(sizeof(liste));
               li->Data = ulist;
               list = li;
               } 
            else 
               {
               /* get new element */
               li->P2L = (L *) mallocs(sizeof(liste));
               /* insert the new */
               li = li->P2L;
               /* insert sub list */
               li->Data = ulist;
               }    
            }
         wert[0] = getc(infile);   
         if (wert[0] == '#') 
            {
            while ((wert[0] != '\n') && (wert[0] != -1)) wert[0] = getc(infile);
            wert[0] = getc(infile);
            }
         else if (!((wert[0] == '1') || (wert[0] == '0') || (wert[0] == -1)))
            if (!((wert[0] == '2') || (wert[0] == '\n'))) fileerror = BAD_FILE;   
         }
      /* end list */   
      if (li != NULL) li->P2L = NULL;  
      /* close file */
      fclose(infile);
      }
   else fileerror = NOT_EXIST;
   if (fileerror != SUCCESS) list = (L *) clearlogic(list); 
   return(list);
   }

void writelogic(char *filename,listptr li)
   {
   FILE *outfile;
   UINT *value;
   char *mode = "w+";
   char wert[2];
   listptr ulist; 
   /* open file */
   outfile = fopen(filename,mode);
   /* if not end of list */
   while (li != NULL)
      {
      /* load sublist */
      ulist = (L *) li->Data;
      /* if not end of sub list */
      while (ulist != NULL)
         {
         /* load logic data */
         value = (UINT *) ulist->Data;
   	 sprintf(wert,"%i",*value);
   	 /* write to file */
         putc(wert[0],outfile);
         /* next */
         ulist = ulist->P2L; 
         }
      /* write \n at end of sub list */   
      putc('\n',outfile);
      /* next */
      li = li->P2L;   
      }
   /* close file */   
   fclose(outfile);
   }   

void *clearlogic(listptr li)
   {
   listptr oldlist = li;
   /* if not end of list */
   while (li != NULL)
      {
      /* delete all lements */
      li->Data = lreplace_a((L *) li->Data);
      /* pointer to next */
      li = li->P2L;
      }
   /* delete main list */   
   li = (L *) lreplace_a(oldlist);
   return(NULL);   
   } 
   
unsigned int llength(listptr li)
   {
   register unsigned int count = 0;
   /* if not end of list */
   while (li != NULL)
      {
      /* pointer to next */
      li = li->P2L;
      count++;
      }
   return(count);   
   }

void *lconcat(listptr li1, listptr li2)
   {
   listptr mark = li1;
   /* goto end of list */
   if (li1 != NULL)
      {
      while (li1->P2L != NULL) li1 = li1->P2L;
      /* concat */
      li1->P2L = li2;
      }
   else
      {
      mark = li2;
      }   
   return(mark);
   }

UINT lcomp_a(listptr Ausdr1, listptr Ausdr2)
   {
   UINT erg = 0;
   listptr buffer, mark;
   /* get list length */
   unsigned int length = llength(Ausdr1);
   unsigned int slength = length - 1;
   /* both same length */
   if (length == llength(Ausdr2))
      {
      length--;
      /* for all elements of Ausdr1 */
      for (register unsigned int Index1 = 0; Index1 <= length; Index1++)
         {
         erg = 0;
         /* next element from Ausdr1 */
         buffer = (L *) lindex(Ausdr1,Index1);
         /* for every element of Ausdr2 */
         for (register unsigned int Index2 = 0; Index2 <= slength; Index2++)
            {
            mark = (L *) lindex(Ausdr2,Index2);
            /* if elements equal */
            if ((erg = lcomp(buffer,mark)) == 1) 
               {
               /* replace element */
               lreplace_a(mark);
               /* replace index in main list */
               Ausdr2 = (L *) lreplace(Ausdr2,Index2);
               if (slength > 0) slength--;
               break;
               }
            }
         /* if no match */   
         if (erg != 1) break;    
         }
      }
   /* replace Ausdr2 */   
   clearlogic(Ausdr2);   
   return(erg);   
   }

void *lcopy(listptr Ausdr)
   {
   bool first1 = false;
   listptr erg = NULL;
   UINT *element;
   listptr ulist, newlist;
   listptr mark = NULL;
   listptr newulist = NULL;
   listptr newmark = NULL;
   /* if not end of list */
   while(Ausdr != NULL)
      {
      /* get new element */
      newlist = (L *) mallocs(sizeof(liste));
      newlist->P2L = NULL;
      /* special case first element */
      if (first1 == false)
         {
         first1 = true;
         erg = newlist;
         } 
      else 
         {
         /* insert new element */
         newmark->P2L = newlist; 
         }
      /* sav sub list pointer */   
      ulist = (L *) Ausdr->Data;
      /* if not sub list end */
      bool first2 = false;
      while (ulist != NULL)
         {
         /* get new element */
         newulist = (L *) mallocs(sizeof(liste));
         newulist->P2L = NULL;
         /* special case first element */
         if (first2 == false)
            {
            first2 = true;
            /* insert new sub list */
            newlist->Data = (void *) newulist;  
            } 
         else 
            {
            /* insert new sub list */
            mark->P2L = newulist;
            }
         /* get new logic data */   
         element = (UINT *) mallocs(sizeof(UINT));
         /* insert new element */
         *element = *((UINT *) ulist->Data);
         newulist->Data = (void *) element;   
         /* next */
         if (mark != NULL) 
            {
            mark = mark->P2L;       
            } 
         else 
            {
            mark = newulist;
            }
         ulist = ulist->P2L; 
         }
      newulist = NULL;
      mark = NULL;
      /* next */
      if (newmark != NULL) newmark = newmark->P2L;
      else newmark = newlist;
      Ausdr = (L *) Ausdr->P2L;   
      }
   /* return new list */   
   return(erg);   
   }    
   
void *lcopy_u(listptr liste)
   {
   listptr erg = NULL;
   listptr nlist = NULL;
   listptr mark = NULL;
   UINT *element;
   bool first = true;
   /* end of list ? */
   while(liste != NULL)
      {
      /* get new element */
      nlist = (L *) mallocs(sizeof(liste));
      element = (UINT *) mallocs(sizeof(UINT));
      /* insert logic data */
      nlist->Data = element;
      *element = *((UINT *) liste->Data);
      /* special case first element */
      if (first == true)
         {
         first = false;
         erg = nlist;
         /* not first element */
         } 
      else 
         {
         mark->P2L = nlist;
         }
      mark = nlist;
      /* pointer to next */
      liste = liste->P2L;
      }
   nlist->P2L = NULL;    
   /* return copy */
   return(erg);
   }
   
unsigned int Count_DC(listptr li)
   {
   register unsigned int count = 0;
   UINT *element;
   /* if not end of list */
   while(li != NULL)
      {
      /* load element */
      element = (UINT *) li->Data;
      /* if dont care increment counter */
      if (*element == 2) count++;
      /* pointer to next element */
      li = li->P2L;
      }
   return(count);   
   }
