/* Copyright is licensed under GNU LGPL.                (I.J. Wang, 2003)
*/

#include "wxterminal.h"
#include <unistd.h>

const char WxTerminal::class_name[]="WxTerminal";

WxTerminal::WxTerminal(const WxTerminal& src) throw(std::exception,WxRet)
try : WxChrFile(src) {
}
catch(const WxChrFile::Fault& e) {
  throw WxTerminal::Fault(e);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxTerminal::~WxTerminal() throw(std::exception)
try {
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::drain(void) throw(std::exception)
try { 
 if(::tcdrain(WxChrFile::fh().fd())!=0) {
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::assignf(const WxTerminal& src) throw(std::exception)
try { 
 WX_RETURN( WxChrFile::assignf(src) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::assignf(WxFileHandle fh) throw(std::exception)
try {
  if(fh.is_default()==false) {
    if(::isatty(fh.fd())==0) {
      WX_RETURN(WXM_EBADF);
    }
  }
  WX_RETURN( WxByteFlow::wx_assignf(fh) );
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};
WxRet WxTerminal::sendbreak(int duration) throw(std::exception)
try {
 if(::tcsendbreak(WxChrFile::fh().fd(),duration)!=0) {
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::flush(int qsel) throw(std::exception)
try { 
 if(::tcflush(WxChrFile::fh().fd(), qsel)!=0) {
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::flow(int duration) throw(std::exception)
try {
 if(::tcflow(WxChrFile::fh().fd(),duration)!=0) {
   WX_RETURN(WxErrMsg(errno));
 }
 return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::getattr(WxTermios& tio) const throw(std::exception)
try {
  if(::tcgetattr(WxChrFile::fh().fd(),&tio._tio)!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::setattr(const WxTermios& tio, int option) throw(std::exception)
try {
  if(::tcsetattr(WxChrFile::fh().fd(),option,&tio._tio)!=0) {
    WX_RETURN(WxErrMsg(errno));
  }
  return(OK);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTerminal::devname(WxPathName& pathname) const throw(std::exception)
try {
  return WxChrFile::wx_devname(pathname);
}
catch(const Wx_general_error&) {
  throw;
}
catch(const Wx_bad_errno&) {
  throw;
}
catch(const Wx_bad_alloc&) {
  throw;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

//-------------------------------------------------------------------------------------
const char WxTermios::class_name[]="WxTermios";

WxTermios::WxTermios(const WxTermios& src) throw(std::exception)
try {
  if(&src==this) {
    WX_THROW(Wx_general_error());
  }
  _tio=src._tio;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

bool WxTermios::is_default(void) const throw(std::exception)
try {
static const WxTermios default_obj;
 return std::memcmp(&_tio,&default_obj._tio,sizeof(_tio))==0;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

void WxTermios::assign(const WxTermios& tio) throw(std::exception)
try {
  if(&tio==this) {
    return;
  }
  _tio=tio._tio;
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

speed_t WxTermios::getispeed(void) const throw(std::exception)
try {
 return ::cfgetispeed(&_tio);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

speed_t WxTermios::getospeed(void) const throw(std::exception)
try {
 return ::cfgetospeed(&_tio);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTermios::setispeed(speed_t speed) throw(std::exception)
try {
 if(::cfsetispeed(&_tio,speed)!=0) {
   WX_RETURN(WXM_EINVAL);       // document does not indicate any error code
 }
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

WxRet WxTermios::setospeed(speed_t speed) throw(std::exception)
try {
 if(::cfsetospeed(&_tio,speed)!=0) {
   WX_RETURN(WXM_EINVAL);       // document does not indicate any error code
 }
 return(OK);
}
catch(const std::bad_alloc&) {
  WX_THROW( Wx_bad_alloc() );
}
catch(...) {
 WX_THROW(Wx_general_error());
};

